/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.db.impl;

import java.util.Collection;
import java.util.Map;
import org.limewire.mojito.KUID;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.db.Database;
import org.limewire.mojito.db.DatabaseSecurityConstraint;
import org.limewire.mojito.settings.DatabaseSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDatabaseSecurityConstraint
implements DatabaseSecurityConstraint {
    private static final long serialVersionUID = 4513377023367562179L;

    @Override
    public boolean allowStore(Database database, Map<KUID, DHTValueEntity> bag, DHTValueEntity entity) {
        if (entity.isLocalValue()) {
            return true;
        }
        int maxDatabaseSize = DatabaseSettings.MAX_DATABASE_SIZE.getValue();
        int maxValuesPerKey = DatabaseSettings.MAX_VALUES_PER_KEY.getValue();
        if (bag == null) {
            return maxDatabaseSize < 0 || database.getKeyCount() < maxDatabaseSize;
        }
        DHTValueEntity existing = bag.get(entity.getSecondaryKey());
        if (existing == null) {
            if (maxValuesPerKey < 0 || bag.size() < maxValuesPerKey) {
                return true;
            }
            if (entity.getCreator().isFirewalled()) {
                return false;
            }
            DHTValueEntity firewalled = this.getOldestFirewalledValue(bag.values());
            if (firewalled != null) {
                database.remove(firewalled.getPrimaryKey(), firewalled.getSecondaryKey());
                return true;
            }
            return false;
        }
        return this.allowReplace(database, bag, existing, entity);
    }

    private boolean allowReplace(Database database, Map<KUID, DHTValueEntity> bag, DHTValueEntity existing, DHTValueEntity entity) {
        if (existing.isLocalValue() && !entity.isLocalValue()) {
            return false;
        }
        if (existing.isDirect() && !entity.isDirect()) {
            return false;
        }
        return entity.isDirect() || entity.getValue().size() != 0;
    }

    private DHTValueEntity getOldestFirewalledValue(Collection<DHTValueEntity> entities) {
        DHTValueEntity oldest = null;
        for (DHTValueEntity entity : entities) {
            if (entity.isLocalValue() || !entity.getCreator().isFirewalled() || oldest != null && entity.getCreationTime() >= oldest.getCreationTime()) continue;
            oldest = entity;
        }
        return oldest;
    }
}

