/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.handler.request;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.handler.request.AbstractRequestHandler;
import org.limewire.mojito.messages.FindNodeResponse;
import org.limewire.mojito.messages.LookupRequest;
import org.limewire.mojito.messages.RequestMessage;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.RouteTable;
import org.limewire.mojito.settings.KademliaSettings;
import org.limewire.mojito.util.CollectionUtils;
import org.limewire.mojito.util.ContactUtils;

public class FindNodeRequestHandler
extends AbstractRequestHandler {
    private static final Log LOG = LogFactory.getLog(FindNodeRequestHandler.class);

    public FindNodeRequestHandler(Context context) {
        super(context);
    }

    protected void request(RequestMessage message) throws IOException {
        LookupRequest request = (LookupRequest)message;
        KUID lookupId = request.getLookupID();
        Contact node = request.getContact();
        Collection<Object> nodes = Collections.emptyList();
        if (!this.context.isBootstrapping()) {
            if (this.context.isFirewalled()) {
                nodes = ContactUtils.sort(this.context.getRouteTable().getContacts(), KademliaSettings.REPLICATION_PARAMETER.getValue());
                if (this.context.getExternalPort() == 0) {
                    nodes.remove(this.context.getLocalNode());
                }
            } else {
                nodes = this.context.getRouteTable().select(lookupId, KademliaSettings.REPLICATION_PARAMETER.getValue(), RouteTable.SelectMode.ALIVE);
            }
        }
        if (LOG.isTraceEnabled()) {
            if (!nodes.isEmpty()) {
                LOG.trace("Sending back: " + CollectionUtils.toString(nodes) + " to: " + node);
            } else {
                LOG.trace("Sending back an empty list to: " + node);
            }
        }
        this.context.getNetworkStats().LOOKUP_REQUESTS.incrementStat();
        FindNodeResponse response = this.context.getMessageHelper().createFindNodeResponse(request, nodes);
        this.context.getMessageDispatcher().send(node, response);
    }
}

