/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.handler.request;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.db.DHTValueType;
import org.limewire.mojito.db.Database;
import org.limewire.mojito.handler.request.AbstractRequestHandler;
import org.limewire.mojito.handler.request.FindNodeRequestHandler;
import org.limewire.mojito.messages.FindValueRequest;
import org.limewire.mojito.messages.FindValueResponse;
import org.limewire.mojito.messages.RequestMessage;
import org.limewire.mojito.util.CollectionUtils;
import org.limewire.mojito.util.DatabaseUtils;

public class FindValueRequestHandler
extends AbstractRequestHandler {
    private static final Log LOG = LogFactory.getLog(FindValueRequestHandler.class);
    private final FindNodeRequestHandler findNodeDelegate;

    public FindValueRequestHandler(Context context, FindNodeRequestHandler findNodeDelegate) {
        super(context);
        this.findNodeDelegate = findNodeDelegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void request(RequestMessage message) throws IOException {
        Database database;
        FindValueRequest request = (FindValueRequest)message;
        KUID lookupId = request.getLookupID();
        DHTValueType valueType = request.getDHTValueType();
        Map<KUID, DHTValueEntity> bag = null;
        float requestLoad = 0.0f;
        Database database2 = database = this.context.getDatabase();
        synchronized (database2) {
            bag = database.get(lookupId);
            requestLoad = database.getRequestLoad(lookupId, true);
        }
        Set<KUID> availableKeys = Collections.emptySet();
        Set valuesToReturn = Collections.emptySet();
        Collection<KUID> requestedSecondaryKeys = request.getSecondaryKeys();
        if (bag != null && !bag.isEmpty()) {
            availableKeys = new HashSet();
            valuesToReturn = new HashSet();
            Collection<? extends DHTValueEntity> filtered = DatabaseUtils.filter(valueType, bag.values());
            if (requestedSecondaryKeys.isEmpty()) {
                if (valuesToReturn.isEmpty() && filtered.size() == 1) {
                    valuesToReturn.addAll(filtered);
                } else {
                    for (DHTValueEntity dHTValueEntity : filtered) {
                        availableKeys.add(dHTValueEntity.getSecondaryKey());
                    }
                }
            } else {
                for (DHTValueEntity dHTValueEntity : filtered) {
                    KUID secondaryKey = dHTValueEntity.getSecondaryKey();
                    if (!requestedSecondaryKeys.contains(secondaryKey)) continue;
                    valuesToReturn.add(dHTValueEntity);
                }
            }
        }
        if (valuesToReturn.isEmpty() && availableKeys.isEmpty()) {
            if (LOG.isInfoEnabled()) {
                LOG.info("No values for " + lookupId + ", returning Contacts instead to " + request.getContact());
            }
            this.findNodeDelegate.handleRequest(message);
        } else {
            if (LOG.isInfoEnabled()) {
                LOG.info("Return " + CollectionUtils.toString(valuesToReturn) + " and " + CollectionUtils.toString(availableKeys) + " for " + lookupId + " to " + request.getContact());
            }
            this.context.getNetworkStats().FIND_VALUE_REQUESTS.incrementStat();
            FindValueResponse response = this.context.getMessageHelper().createFindValueResponse(request, requestLoad, valuesToReturn, availableKeys);
            this.context.getMessageDispatcher().send(request.getContact(), response);
        }
    }
}

