/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.handler.request;

import java.io.IOException;
import java.io.StringWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.mojito.Context;
import org.limewire.mojito.handler.request.AbstractRequestHandler;
import org.limewire.mojito.messages.RequestMessage;
import org.limewire.mojito.messages.StatsRequest;
import org.limewire.mojito.messages.StatsResponse;
import org.limewire.mojito.statistics.NetworkStatisticContainer;

public class StatsRequestHandler
extends AbstractRequestHandler {
    private static final Log LOG = LogFactory.getLog(StatsRequestHandler.class);
    private final NetworkStatisticContainer networkStats;

    public StatsRequestHandler(Context context) {
        super(context);
        this.networkStats = context.getNetworkStats();
    }

    public void request(RequestMessage message) throws IOException {
        StatsRequest request = (StatsRequest)message;
        if (!request.isSecure()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn(message.getContact() + " sent us an invalid Stats Request");
            }
            return;
        }
        this.networkStats.STATS_REQUEST.incrementStat();
        StringWriter writer = new StringWriter();
        switch (request.getType()) {
            case STATISTICS: {
                this.context.getDHTStats().dump(writer, false);
                break;
            }
            case DATABASE: {
                writer.write(this.context.getDatabase().toString());
                break;
            }
            case ROUTETABLE: {
                writer.write(this.context.getRouteTable().toString());
                break;
            }
            default: {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Unknown stats request: " + (Object)((Object)request.getType()));
                }
                return;
            }
        }
        StatsResponse response = this.context.getMessageHelper().createStatsResponse(message, writer.toString().getBytes("ISO-8859-1"));
        this.context.getMessageDispatcher().send(message.getContact(), response);
    }
}

