/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.handler.request;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.mojito.Context;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.db.Database;
import org.limewire.mojito.handler.request.AbstractRequestHandler;
import org.limewire.mojito.messages.RequestMessage;
import org.limewire.mojito.messages.StoreRequest;
import org.limewire.mojito.messages.StoreResponse;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.statistics.NetworkStatisticContainer;
import org.limewire.security.SecurityToken;

public class StoreRequestHandler
extends AbstractRequestHandler {
    private static final Log LOG = LogFactory.getLog(StoreRequestHandler.class);
    private NetworkStatisticContainer networkStats;

    public StoreRequestHandler(Context context) {
        super(context);
        this.networkStats = context.getNetworkStats();
    }

    public void request(RequestMessage message) throws IOException {
        StoreRequest request = (StoreRequest)message;
        this.networkStats.STORE_REQUESTS.incrementStat();
        SecurityToken securityToken = request.getSecurityToken();
        if (securityToken == null) {
            if (LOG.isErrorEnabled()) {
                LOG.error(request.getContact() + " does not provide a SecurityToken");
            }
            this.networkStats.STORE_REQUESTS_NO_QK.incrementStat();
            return;
        }
        Contact src = request.getContact();
        SecurityToken.TokenData expectedToken = this.context.getSecurityTokenHelper().createTokenData(src);
        if (!securityToken.isFor(expectedToken)) {
            if (LOG.isErrorEnabled()) {
                LOG.error(request.getContact() + " send us an invalid SecurityToken " + securityToken);
            }
            this.networkStats.STORE_REQUESTS_BAD_QK.incrementStat();
            return;
        }
        Collection<? extends DHTValueEntity> values = request.getDHTValueEntities();
        ArrayList<StoreResponse.StoreStatusCode> status = new ArrayList<StoreResponse.StoreStatusCode>(values.size());
        Database database = this.context.getDatabase();
        for (DHTValueEntity dHTValueEntity : values) {
            if (database.store(dHTValueEntity)) {
                this.networkStats.STORE_REQUESTS_OK.incrementStat();
                status.add(new StoreResponse.StoreStatusCode(dHTValueEntity, StoreResponse.OK));
                continue;
            }
            this.networkStats.STORE_REQUESTS_FAILURE.incrementStat();
            status.add(new StoreResponse.StoreStatusCode(dHTValueEntity, StoreResponse.ERROR));
        }
        StoreResponse response = this.context.getMessageHelper().createStoreResponse(request, status);
        this.context.getMessageDispatcher().send(request.getContact(), response);
    }
}

