/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.handler.response;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.PatriciaTrie;
import org.limewire.collection.Trie;
import org.limewire.collection.TrieUtils;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.exceptions.DHTBackendException;
import org.limewire.mojito.exceptions.DHTException;
import org.limewire.mojito.handler.ResponseHandler;
import org.limewire.mojito.handler.response.AbstractResponseHandler;
import org.limewire.mojito.messages.FindNodeResponse;
import org.limewire.mojito.messages.LookupRequest;
import org.limewire.mojito.messages.RequestMessage;
import org.limewire.mojito.messages.ResponseMessage;
import org.limewire.mojito.messages.SecurityTokenProvider;
import org.limewire.mojito.result.LookupResult;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.RouteTable;
import org.limewire.mojito.settings.KademliaSettings;
import org.limewire.mojito.settings.LookupSettings;
import org.limewire.mojito.util.ContactUtils;
import org.limewire.mojito.util.ContactsScrubber;
import org.limewire.mojito.util.EntryImpl;
import org.limewire.security.SecurityToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LookupResponseHandler<V extends LookupResult>
extends AbstractResponseHandler<V> {
    private static final Log LOG = LogFactory.getLog(LookupResponseHandler.class);
    protected final KUID lookupId;
    private final KUID furthestId;
    protected final Set<KUID> queried = new LinkedHashSet<KUID>();
    protected final Trie<KUID, Contact> toQuery = new PatriciaTrie<KUID, Contact>(KUID.KEY_ANALYZER);
    protected final Trie<KUID, Map.Entry<Contact, SecurityToken>> responsePath = new PatriciaTrie<KUID, Map.Entry<Contact, SecurityToken>>(KUID.KEY_ANALYZER);
    private final Map<KUID, Integer> hopMap = new HashMap<KUID, Integer>();
    private final Set<KUID> routeTableNodes = new LinkedHashSet<KUID>();
    private final Set<Contact> forcedContacts = new LinkedHashSet<Contact>();
    protected final Collection<Contact> collisions = new LinkedHashSet<Contact>();
    private int activeSearches = 0;
    private int currentHop = 0;
    private int resultSetSize;
    private int parellelism;
    private boolean selectAliveNodesOnly = false;
    private long startTime = -1L;
    private int routeTableFailureCount = 0;
    private int totalFailures = 0;
    private boolean deleteFurthest = true;

    protected LookupResponseHandler(Context context, KUID lookupId) {
        super(context);
        this.lookupId = lookupId;
        this.furthestId = lookupId.invert();
        this.setMaxErrors(0);
        this.setParallelism(-1);
        this.setResultSetSize(-1);
        this.setDeleteFurthest(LookupSettings.DELETE_FURTHEST_CONTACT.getValue());
    }

    public KUID getLookupID() {
        return this.lookupId;
    }

    public void setResultSetSize(int resultSetSize) {
        if (resultSetSize < 0) {
            this.resultSetSize = KademliaSettings.REPLICATION_PARAMETER.getValue();
        } else if (resultSetSize > 0) {
            this.resultSetSize = resultSetSize;
        } else {
            throw new IllegalArgumentException("resultSetSize=" + resultSetSize);
        }
    }

    public int getResultSetSize() {
        return this.resultSetSize;
    }

    public void setParallelism(int parellelism) {
        if (parellelism < 0) {
            this.parellelism = this.getDefaultParallelism();
        } else if (parellelism > 0) {
            this.parellelism = parellelism;
        } else {
            throw new IllegalArgumentException("parellelism=" + parellelism);
        }
    }

    protected abstract int getDefaultParallelism();

    public int getParallelism() {
        return this.parellelism;
    }

    public void addForcedContact(Contact node) {
        this.forcedContacts.add(node);
    }

    public Collection<Contact> getForcedContacts() {
        return Collections.unmodifiableSet(this.forcedContacts);
    }

    @Override
    public long getElapsedTime() {
        if (this.startTime > 0L) {
            return System.currentTimeMillis() - this.startTime;
        }
        return -1L;
    }

    public int getRouteTableFailureCount() {
        return this.routeTableFailureCount;
    }

    protected abstract boolean isTimeout(long var1);

    public void setSelectAliveNodesOnly(boolean selectAliveNodesOnly) {
        this.selectAliveNodesOnly = selectAliveNodesOnly;
    }

    public boolean isSelectAliveNodesOnly() {
        return this.selectAliveNodesOnly;
    }

    public void setDeleteFurthest(boolean deleteFurthest) {
        this.deleteFurthest = deleteFurthest;
    }

    public boolean isDeleteFurthest() {
        return this.deleteFurthest;
    }

    @Override
    protected void start() throws DHTException {
        Contact mrs;
        Collection<Contact> nodes = null;
        nodes = this.isSelectAliveNodesOnly() ? this.context.getRouteTable().select(this.lookupId, 2 * this.getResultSetSize(), RouteTable.SelectMode.ALIVE) : this.context.getRouteTable().select(this.lookupId, this.getResultSetSize(), RouteTable.SelectMode.ALL);
        for (Contact node : nodes) {
            this.addYetToBeQueried(node, this.currentHop + 1);
            this.routeTableNodes.add(node.getNodeID());
        }
        this.addToResponsePath(this.context.getLocalNode(), null);
        this.markAsQueried(this.context.getLocalNode());
        ArrayList<Contact> alphaList = new ArrayList<Contact>(this.getContactsToQuery(this.lookupId, this.getParallelism()));
        if (alphaList.size() >= 3 && !alphaList.contains(mrs = ContactUtils.getMostRecentlySeen(nodes = ContactUtils.sort(nodes))) && !this.context.isLocalNode(mrs)) {
            if (alphaList.size() >= this.getParallelism()) {
                alphaList.remove(alphaList.size() - 1);
            }
            alphaList.add(mrs);
        }
        for (Contact forced : this.forcedContacts) {
            if (alphaList.contains(forced)) continue;
            alphaList.add(0, forced);
            this.hopMap.put(forced.getNodeID(), this.currentHop + 1);
            int last = alphaList.size() - 1;
            if (alphaList.size() <= this.getParallelism() || this.forcedContacts.contains(alphaList.get(last))) continue;
            alphaList.remove(last);
        }
        this.startTime = System.currentTimeMillis();
        for (Contact node : alphaList) {
            try {
                this.lookup(node);
            }
            catch (IOException err) {
                throw new DHTException(err);
            }
        }
        this.finishLookupIfDone();
    }

    @Override
    protected void response(ResponseMessage message, long time) throws IOException {
        this.decrementActiveSearches();
        Contact contact = message.getContact();
        Integer hop = this.hopMap.remove(contact.getNodeID());
        assert (hop != null);
        this.currentHop = hop;
        if (this.nextStep(message)) {
            this.nextLookupStep();
        }
        this.finishLookupIfDone();
    }

    protected abstract boolean nextStep(ResponseMessage var1) throws IOException;

    protected final boolean handleNodeResponse(FindNodeResponse response) {
        Contact sender = response.getContact();
        Collection<? extends Contact> nodes = response.getNodes();
        if (nodes.isEmpty()) {
            if (LookupSettings.ACCEPT_EMPTY_FIND_NODE_RESPONSES.getValue()) {
                this.addToResponsePath(response);
            }
            return true;
        }
        ContactsScrubber scrubber = ContactsScrubber.scrub(this.context, sender, nodes, LookupSettings.CONTACTS_SCRUBBER_REQUIRED_RATIO.getValue());
        if (scrubber.isValidResponse()) {
            for (Contact node : scrubber.getScrubbed()) {
                if (this.isQueried(node) || this.isYetToBeQueried(node)) continue;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Adding " + node + " to the yet-to-be queried list");
                }
                this.addYetToBeQueried(node, this.currentHop + 1);
                assert (!node.isAlive());
                this.context.getRouteTable().add(node);
            }
            this.collisions.addAll(scrubber.getCollisions());
            this.addToResponsePath(response);
        }
        return true;
    }

    @Override
    protected void timeout(KUID nodeId, SocketAddress dst, RequestMessage message, long time) throws IOException {
        this.decrementActiveSearches();
        if (LOG.isTraceEnabled()) {
            LOG.trace(ContactUtils.toString(nodeId, dst) + " did not respond to our " + message);
        }
        Integer hop = this.hopMap.remove(nodeId);
        assert (hop != null);
        if (this.routeTableNodes.contains(nodeId)) {
            ++this.routeTableFailureCount;
        }
        ++this.totalFailures;
        this.currentHop = hop;
        this.nextLookupStep();
        this.finishLookupIfDone();
    }

    @Override
    protected void error(KUID nodeId, SocketAddress dst, RequestMessage message, IOException e) {
        if (e instanceof SocketException && this.hasActiveSearches()) {
            try {
                this.timeout(nodeId, dst, message, -1L);
            }
            catch (IOException err) {
                LOG.error("IOException", err);
                if (!this.hasActiveSearches()) {
                    this.setException(new DHTException(err));
                }
            }
        } else {
            this.setException(new DHTBackendException(nodeId, dst, message, e));
        }
    }

    protected void nextLookupStep() throws IOException {
        int numLookups;
        long totalTime = this.getElapsedTime();
        if (this.isTimeout(totalTime)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Lookup for " + this.lookupId + " terminates after " + this.currentHop + " hops and " + totalTime + "ms due to timeout.");
            }
            this.killActiveSearches();
            return;
        }
        if (!this.hasActiveSearches()) {
            if (!this.hasContactsToQuery()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Lookup for " + this.lookupId + " terminates after " + this.currentHop + " hops and " + totalTime + "ms. No contacts left to query.");
                }
                return;
            }
            if (!this.context.isLocalNodeID(this.lookupId) && this.responsePath.containsKey(this.lookupId)) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Lookup for " + this.lookupId + " terminates after " + this.currentHop + " hops. Found target ID!");
                }
                return;
            }
        }
        if (this.responsePath.size() >= this.getResultSetSize()) {
            KUID worst = this.responsePath.select(this.furthestId).getKey().getNodeID();
            KUID best = null;
            if (!this.toQuery.isEmpty()) {
                best = this.toQuery.select(this.lookupId).getNodeID();
            }
            if (best == null || worst.isNearerTo(this.lookupId, best)) {
                if (!this.hasActiveSearches() && LOG.isTraceEnabled()) {
                    Contact bestResponse = this.responsePath.select(this.lookupId).getKey();
                    LOG.trace("Lookup for " + this.lookupId + " terminates after " + this.currentHop + " hops, " + totalTime + "ms and " + this.queried.size() + " queried Nodes with " + bestResponse + " as best match");
                }
                return;
            }
        }
        if ((numLookups = this.getParallelism() - this.getActiveSearches()) > 0) {
            Collection<Contact> toQueryList = this.getContactsToQuery(this.lookupId, numLookups);
            for (Contact node : toQueryList) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Sending " + node + " a find request for " + this.lookupId);
                }
                try {
                    this.lookup(node);
                }
                catch (SocketException err) {
                    LOG.error("A SocketException occurred", err);
                }
            }
        }
    }

    protected boolean lookup(Contact node) throws IOException {
        LookupRequest request = this.createLookupRequest(node);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Sending " + node + " a " + request);
        }
        this.markAsQueried(node);
        boolean requestWasSent = this.context.getMessageDispatcher().send(node, (RequestMessage)request, (ResponseHandler)this);
        if (requestWasSent) {
            this.incrementActiveSearches();
        }
        return requestWasSent;
    }

    protected abstract LookupRequest createLookupRequest(Contact var1);

    private void finishLookupIfDone() {
        if (!(this.isDone() || this.isCancelled() || this.hasActiveSearches())) {
            this.finishLookup();
        }
    }

    protected abstract void finishLookup();

    protected void incrementActiveSearches() {
        ++this.activeSearches;
    }

    protected void decrementActiveSearches() {
        if (this.activeSearches == 0) {
            if (LOG.isErrorEnabled()) {
                LOG.error("ActiveSearches counter is already 0");
            }
            return;
        }
        --this.activeSearches;
    }

    protected void killActiveSearches() {
        this.activeSearches = 0;
    }

    protected int getActiveSearches() {
        return this.activeSearches;
    }

    protected boolean hasActiveSearches() {
        return this.getActiveSearches() > 0;
    }

    protected boolean isQueried(Contact node) {
        return this.queried.contains(node.getNodeID());
    }

    protected void markAsQueried(Contact node) {
        this.queried.add(node.getNodeID());
        this.toQuery.remove(node.getNodeID());
    }

    protected boolean isYetToBeQueried(Contact node) {
        return this.toQuery.containsKey(node.getNodeID());
    }

    protected boolean hasContactsToQuery() {
        return !this.toQuery.isEmpty();
    }

    protected Collection<Contact> getContactsToQuery(KUID lookupId, int count) {
        return TrieUtils.select(this.toQuery, lookupId, count);
    }

    protected boolean addYetToBeQueried(Contact node, int hop) {
        if (this.isQueried(node)) {
            return false;
        }
        KUID nodeId = node.getNodeID();
        if (this.context.isLocalNodeID(nodeId) || this.context.isLocalContactAddress(node.getContactAddress())) {
            if (LOG.isInfoEnabled()) {
                LOG.info(node + " has either the same NodeID or contact" + " address as the local Node " + this.context.getLocalNode());
            }
            return false;
        }
        this.toQuery.put(nodeId, node);
        this.hopMap.put(nodeId, hop);
        return true;
    }

    protected void addToResponsePath(ResponseMessage response) {
        Contact sender = response.getContact();
        SecurityToken securityToken = null;
        if (response instanceof SecurityTokenProvider) {
            securityToken = ((SecurityTokenProvider)((Object)response)).getSecurityToken();
        }
        this.addToResponsePath(sender, securityToken);
    }

    protected void addToResponsePath(Contact node, SecurityToken securityToken) {
        EntryImpl<Contact, SecurityToken> entry = new EntryImpl<Contact, SecurityToken>(node, securityToken, true);
        this.responsePath.put(node.getNodeID(), entry);
        if (this.isDeleteFurthest() && this.responsePath.size() > this.getResultSetSize()) {
            Contact worst = this.responsePath.select(this.furthestId).getKey();
            this.responsePath.remove(worst.getNodeID());
        }
    }

    protected Map<Contact, SecurityToken> getPath() {
        return this.getContacts(this.responsePath.size());
    }

    protected Map<Contact, SecurityToken> getNearestContacts() {
        return this.getContacts(this.getResultSetSize());
    }

    protected Map<Contact, SecurityToken> getContacts(int count) {
        if (count < 0) {
            count = this.responsePath.size();
        }
        final int maxCount = count;
        final LinkedHashMap<Contact, SecurityToken> nearest = new LinkedHashMap<Contact, SecurityToken>();
        this.responsePath.select(this.lookupId, new Trie.Cursor<KUID, Map.Entry<Contact, SecurityToken>>(){

            @Override
            public Trie.Cursor.SelectStatus select(Map.Entry<? extends KUID, ? extends Map.Entry<Contact, SecurityToken>> entry) {
                Map.Entry<Contact, SecurityToken> e = entry.getValue();
                nearest.put(e.getKey(), e.getValue());
                if (nearest.size() < maxCount) {
                    return Trie.Cursor.SelectStatus.CONTINUE;
                }
                return Trie.Cursor.SelectStatus.EXIT;
            }
        });
        return nearest;
    }

    protected Set<KUID> getQueried() {
        return this.queried;
    }

    public int getCurrentHop() {
        return this.currentHop;
    }

    public String toString() {
        long time = this.getElapsedTime();
        boolean timeout = this.isTimeout(time);
        int activeSearches = this.getActiveSearches();
        return ", lookup: " + this.lookupId + ", time: " + time + ", timeout: " + timeout + ", activeSearches: " + activeSearches;
    }
}

