/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.io;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.NetworkUtils;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.exceptions.IllegalSocketAddressException;
import org.limewire.mojito.handler.DefaultMessageHandler;
import org.limewire.mojito.handler.ResponseHandler;
import org.limewire.mojito.handler.request.AbstractRequestHandler;
import org.limewire.mojito.handler.request.FindNodeRequestHandler;
import org.limewire.mojito.handler.request.FindValueRequestHandler;
import org.limewire.mojito.handler.request.PingRequestHandler;
import org.limewire.mojito.handler.request.StatsRequestHandler;
import org.limewire.mojito.handler.request.StoreRequestHandler;
import org.limewire.mojito.io.Tag;
import org.limewire.mojito.messages.DHTMessage;
import org.limewire.mojito.messages.DHTSecureMessage;
import org.limewire.mojito.messages.FindNodeRequest;
import org.limewire.mojito.messages.FindNodeResponse;
import org.limewire.mojito.messages.FindValueRequest;
import org.limewire.mojito.messages.FindValueResponse;
import org.limewire.mojito.messages.MessageFormatException;
import org.limewire.mojito.messages.MessageID;
import org.limewire.mojito.messages.PingRequest;
import org.limewire.mojito.messages.PingResponse;
import org.limewire.mojito.messages.RequestMessage;
import org.limewire.mojito.messages.ResponseMessage;
import org.limewire.mojito.messages.StatsRequest;
import org.limewire.mojito.messages.StatsResponse;
import org.limewire.mojito.messages.StoreRequest;
import org.limewire.mojito.messages.StoreResponse;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.settings.NetworkSettings;
import org.limewire.mojito.util.ContactUtils;
import org.limewire.mojito.util.FixedSizeHashMap;
import org.limewire.mojito.util.HostFilter;
import org.limewire.mojito.util.MessageUtils;
import org.limewire.security.SecureMessage;
import org.limewire.security.SecureMessageCallback;
import org.limewire.util.StringUtils;

public abstract class MessageDispatcher {
    private static final Log LOG = LogFactory.getLog(MessageDispatcher.class);
    private static final int MAX_MESSAGE_SIZE = NetworkSettings.MAX_MESSAGE_SIZE.getValue();
    private final ReceiptMap receiptMap = new ReceiptMap(512);
    protected final Context context;
    private final DefaultMessageHandler defaultHandler;
    private final PingRequestHandler pingHandler;
    private final FindNodeRequestHandler findNodeHandler;
    private final FindValueRequestHandler findValueHandler;
    private final StoreRequestHandler storeHandler;
    private final StatsRequestHandler statsHandler;
    private ScheduledFuture cleanupTaskFuture;
    private final List<MessageDispatcherListener> listeners = new CopyOnWriteArrayList<MessageDispatcherListener>();

    public MessageDispatcher(Context context) {
        this.context = context;
        this.defaultHandler = new DefaultMessageHandler(context);
        this.pingHandler = new PingRequestHandler(context);
        this.findNodeHandler = new FindNodeRequestHandler(context);
        this.findValueHandler = new FindValueRequestHandler(context, this.findNodeHandler);
        this.storeHandler = new StoreRequestHandler(context);
        this.statsHandler = new StatsRequestHandler(context);
    }

    public void addMessageDispatcherListener(MessageDispatcherListener l) {
        if (l == null) {
            throw new NullPointerException("MessageDispatcherListener is null");
        }
        this.listeners.add(l);
    }

    public void removeMessageDispatcherListener(MessageDispatcherListener l) {
        if (l == null) {
            throw new NullPointerException("MessageDispatcherListener is null");
        }
        this.listeners.remove(l);
    }

    public abstract void bind(SocketAddress var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        ReceiptMap receiptMap = this.receiptMap;
        synchronized (receiptMap) {
            if (this.cleanupTaskFuture == null) {
                long delay = NetworkSettings.CLEANUP_RECEIPTS_DELAY.getValue();
                Runnable task = new Runnable(){

                    public void run() {
                        MessageDispatcher.this.process(new CleanupProcessor());
                    }
                };
                this.cleanupTaskFuture = this.context.getDHTExecutorService().scheduleWithFixedDelay(task, 0L, delay, TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        ReceiptMap receiptMap = this.receiptMap;
        synchronized (receiptMap) {
            if (this.cleanupTaskFuture != null) {
                this.cleanupTaskFuture.cancel(true);
                this.cleanupTaskFuture = null;
            }
        }
    }

    public void close() {
        this.stop();
        this.clear();
    }

    public boolean isAccepting() {
        return true;
    }

    public abstract boolean isBound();

    public abstract boolean isRunning();

    public boolean send(Contact contact, ResponseMessage response) throws IOException {
        return this.send(new Tag(contact, response));
    }

    public boolean send(SocketAddress dst, RequestMessage request, ResponseHandler responseHandler) throws IOException {
        return this.send(new Tag(dst, request, responseHandler));
    }

    public boolean send(KUID nodeId, SocketAddress dst, RequestMessage request, ResponseHandler responseHandler) throws IOException {
        return this.send(new Tag(nodeId, dst, request, responseHandler));
    }

    public boolean send(Contact contact, RequestMessage request, ResponseHandler responseHandler) throws IOException {
        return this.send(new Tag(contact, request, responseHandler));
    }

    protected boolean send(Tag tag) throws IOException {
        if (!this.isRunning()) {
            throw new IOException("Cannot send Message because MessageDispatcher is not running");
        }
        KUID nodeId = tag.getNodeID();
        SocketAddress dst = tag.getSocketAddress();
        DHTMessage message = tag.getMessage();
        if (this.context.isLocalContactAddress(dst)) {
            String msg = "Cannot send Message of type " + message.getClass().getName() + " to " + ContactUtils.toString(nodeId, dst) + " because it has the same contact address as the local Node " + this.context.getLocalNode() + " has";
            if (LOG.isInfoEnabled()) {
                LOG.info(msg);
            }
            this.process(new ErrorProcessor(tag, new IOException(msg)));
            return false;
        }
        if (this.context.isLocalNodeID(nodeId) && !MessageUtils.isCollisionPingRequest(this.context.getLocalNodeID(), message)) {
            String msg = "Cannot send Message of type " + message.getClass().getName() + " to " + ContactUtils.toString(nodeId, dst) + " which is equal to our local Node " + this.context.getLocalNode();
            if (LOG.isErrorEnabled()) {
                LOG.error(msg);
            }
            this.process(new ErrorProcessor(tag, new IOException(msg)));
            return false;
        }
        if (!NetworkUtils.isValidSocketAddress(dst)) {
            String msg = "Invalid IP:Port " + ContactUtils.toString(nodeId, dst);
            if (LOG.isErrorEnabled()) {
                LOG.error(msg);
            }
            this.process(new ErrorProcessor(tag, new IllegalSocketAddressException(msg)));
            return false;
        }
        if (ContactUtils.isPrivateAddress(dst)) {
            String msg = "Private IP:Port " + ContactUtils.toString(nodeId, dst);
            if (LOG.isErrorEnabled()) {
                LOG.error(msg);
            }
            this.process(new ErrorProcessor(tag, new IllegalSocketAddressException(msg)));
            return false;
        }
        ByteBuffer data = this.serialize(dst, message);
        int size = data.remaining();
        if (size <= 0) {
            this.process(new ErrorProcessor(tag, new IOException("Illegal Message size: " + size)));
            return false;
        }
        if (size >= MAX_MESSAGE_SIZE && LOG.isWarnEnabled()) {
            LOG.warn("Message (" + message.getClass().getName() + ") is too large: " + size + " >= " + MAX_MESSAGE_SIZE);
        }
        tag.setData(data);
        this.process(new SubmitProcessor(tag));
        return true;
    }

    protected abstract boolean submit(Tag var1);

    protected ByteBuffer serialize(SocketAddress dst, DHTMessage message) throws IOException {
        return this.context.getMessageFactory().writeMessage(dst, message);
    }

    protected DHTMessage deserialize(SocketAddress src, ByteBuffer data) throws MessageFormatException, IOException {
        return this.context.getMessageFactory().createMessage(src, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleMessage(DHTMessage message) {
        if (!this.isAccepting()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Dropping " + message + " because MessageDispatcher is " + "not accepting requests nor responses");
            }
            return;
        }
        Contact node = message.getContact();
        KUID nodeId = node.getNodeID();
        SocketAddress src = node.getContactAddress();
        MessageID messageId = message.getMessageID();
        if (this.context.isLocalContactAddress(src) || this.context.isLocalNodeID(nodeId) && !(message instanceof PingResponse)) {
            if (LOG.isErrorEnabled()) {
                String msg = "Received a message of type " + message.getClass().getName() + " from " + node + " which is equal to our local Node " + this.context.getLocalNode();
                LOG.error(msg);
            }
            return;
        }
        if (!NetworkUtils.isValidSocketAddress(src)) {
            if (LOG.isErrorEnabled()) {
                LOG.error(node + " has an invalid IP:Port");
            }
            return;
        }
        if (!ContactUtils.isSameAddressSpace(this.context.getLocalNode(), node)) {
            if (LOG.isErrorEnabled()) {
                LOG.error(node + " is from a different IP address space than local Node");
            }
            return;
        }
        this.fireMessageReceived(message);
        if (!this.accept(message)) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Dropping message from " + node);
            }
            this.fireMessageFiltered(message);
            return;
        }
        if (message instanceof ResponseMessage) {
            ResponseMessage response = (ResponseMessage)message;
            if (node.isFirewalled() && NetworkSettings.DROP_RESPONE_IF_FIREWALLED.getValue()) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Dropping " + message + " because sender is firewalled");
                }
                return;
            }
            if (messageId.isTaggingSupported() && !messageId.isFor(src)) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn(response.getContact() + " sent us an unsolicited response: " + response);
                }
                return;
            }
            Tag.Receipt receipt = null;
            ReceiptMap receiptMap = this.receiptMap;
            synchronized (receiptMap) {
                receipt = (Tag.Receipt)this.receiptMap.get(messageId);
                if (receipt != null) {
                    receipt.received();
                    if (!receipt.sanityCheck(response)) {
                        if (LOG.isWarnEnabled()) {
                            LOG.warn("Response from " + response.getContact() + " did not pass the sanity check");
                        }
                        return;
                    }
                    message.getContact().setRoundTripTime(receipt.time());
                    this.receiptMap.remove(messageId);
                }
            }
            if (receipt == null && !messageId.isTaggingSupported()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace(response.getContact() + " sent us an unsolicited response: " + response);
                }
                return;
            }
            this.processResponse(receipt, response);
        } else if (message instanceof RequestMessage) {
            if (this.context.getLocalNode().isFirewalled() && NetworkSettings.DROP_REQUEST_IF_FIREWALLED.getValue()) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Local Node is firewalled, dropping " + message);
                }
            } else {
                this.processRequest((RequestMessage)message);
            }
        } else {
            throw new IllegalArgumentException(message + " is neither instance of RequestMessage nor ResponseMessage!");
        }
    }

    private void processResponse(Tag.Receipt receipt, ResponseMessage response) {
        ResponseProcessor processor = new ResponseProcessor(receipt, response);
        if (response instanceof DHTSecureMessage) {
            this.verify((DHTSecureMessage)((Object)response), processor);
        } else {
            this.process(processor);
        }
    }

    private void processRequest(RequestMessage request) {
        RequestProcessor processor = new RequestProcessor(request);
        if (request instanceof DHTSecureMessage) {
            this.verify((DHTSecureMessage)((Object)request), processor);
        } else {
            this.process(processor);
        }
    }

    protected void register(Tag tag) {
        Tag.Receipt receipt = tag.receipt();
        if (receipt != null) {
            this.process(new RegisterProcessor(receipt));
        }
        this.fireMessageSent(tag.getNodeID(), tag.getSocketAddress(), tag.getMessage());
    }

    protected abstract void process(Runnable var1);

    protected abstract void verify(SecureMessage var1, SecureMessageCallback var2);

    protected boolean accept(DHTMessage message) {
        return true;
    }

    protected boolean allow(DHTMessage message) {
        HostFilter hostFilter = this.context.getHostFilter();
        if (hostFilter != null) {
            return hostFilter.allow(message.getContact().getContactAddress());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        ReceiptMap receiptMap = this.receiptMap;
        synchronized (receiptMap) {
            this.receiptMap.clear();
        }
    }

    protected void handleError(Tag tag, IOException err) {
        this.process(new ErrorProcessor(tag, err));
    }

    protected void fireMessageSent(KUID nodeId, SocketAddress dst, DHTMessage message) {
        this.fireMessageDispatcherEvent(nodeId, dst, message, MessageDispatcherEvent.EventType.MESSAGE_SENT);
    }

    protected void fireMessageReceived(DHTMessage message) {
        this.fireMessageDispatcherEvent(null, null, message, MessageDispatcherEvent.EventType.MESSAGE_RECEIVED);
    }

    protected void fireMessageFiltered(DHTMessage message) {
        this.fireMessageDispatcherEvent(null, null, message, MessageDispatcherEvent.EventType.MESSAGE_FILTERED);
    }

    protected void fireLateResponse(DHTMessage message) {
        this.fireMessageDispatcherEvent(null, null, message, MessageDispatcherEvent.EventType.LATE_RESPONSE);
    }

    protected void fireReceiptTimeout(Tag.Receipt receipt) {
        this.fireMessageDispatcherEvent(receipt.getNodeID(), receipt.getSocketAddress(), receipt.getRequestMessage(), MessageDispatcherEvent.EventType.RECEIPT_TIMEOUT);
    }

    protected void fireReceiptEvicted(Tag.Receipt receipt) {
        this.fireMessageDispatcherEvent(receipt.getNodeID(), receipt.getSocketAddress(), receipt.getRequestMessage(), MessageDispatcherEvent.EventType.RECEIPT_EVICTED);
    }

    protected void fireMessageDispatcherEvent(KUID nodeId, SocketAddress dst, DHTMessage message, MessageDispatcherEvent.EventType type) {
        if (this.listeners.isEmpty()) {
            return;
        }
        MessageDispatcherEvent evt = new MessageDispatcherEvent(this, nodeId, dst, message, type);
        for (MessageDispatcherListener listener : this.listeners) {
            listener.handleMessageDispatcherEvent(evt);
        }
    }

    public static class MessageDispatcherEvent {
        private MessageDispatcher messageDispatcher;
        private KUID nodeId;
        private SocketAddress dst;
        private DHTMessage message;
        private EventType type;

        public MessageDispatcherEvent(MessageDispatcher messageDispatcher, KUID nodeId, SocketAddress dst, DHTMessage message, EventType type) {
            this.nodeId = nodeId;
            this.dst = dst;
            this.message = message;
            this.type = type;
        }

        public MessageDispatcher getMessageDispatcher() {
            return this.messageDispatcher;
        }

        public KUID getNodeID() {
            return this.nodeId;
        }

        public SocketAddress getSocketAddress() {
            return this.dst;
        }

        public DHTMessage getMessage() {
            return this.message;
        }

        public EventType getEventType() {
            return this.type;
        }

        public String toString() {
            return StringUtils.toString(this, new Object[]{this.nodeId, this.dst, this.message, this.type});
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum EventType {
            MESSAGE_SENT,
            MESSAGE_RECEIVED,
            MESSAGE_FILTERED,
            RECEIPT_TIMEOUT,
            RECEIPT_EVICTED,
            LATE_RESPONSE;

        }
    }

    public static interface MessageDispatcherListener {
        public void handleMessageDispatcherEvent(MessageDispatcherEvent var1);
    }

    private class ErrorProcessor
    implements Runnable {
        private final Tag tag;
        private final IOException exception;

        private ErrorProcessor(Tag tag, IOException exception) {
            this.tag = tag;
            this.exception = exception;
        }

        public void run() {
            this.tag.handleError(this.exception);
        }
    }

    private class TickProcessor
    implements Runnable {
        private final Tag.Receipt receipt;

        private TickProcessor(Tag.Receipt receipt) {
            this.receipt = receipt;
        }

        public void run() {
            this.receipt.handleTick();
        }
    }

    private class TimeoutProcessor
    implements Runnable {
        private final Tag.Receipt receipt;
        private final boolean timeout;

        private TimeoutProcessor(Tag.Receipt receipt, boolean timeout) {
            this.receipt = receipt;
            this.timeout = timeout;
        }

        public void run() {
            if (this.timeout) {
                MessageDispatcher.this.fireReceiptTimeout(this.receipt);
            } else {
                MessageDispatcher.this.fireReceiptEvicted(this.receipt);
            }
            try {
                KUID nodeId = this.receipt.getNodeID();
                SocketAddress dst = this.receipt.getSocketAddress();
                RequestMessage msg = this.receipt.getRequestMessage();
                long time = this.receipt.time();
                MessageDispatcher.this.defaultHandler.handleTimeout(nodeId, dst, msg, time);
                this.receipt.getResponseHandler().handleTimeout(nodeId, dst, msg, time);
            }
            catch (IOException e) {
                this.receipt.handleError(e);
                LOG.error("ReceiptMap removeEldestEntry error: ", e);
            }
        }
    }

    private class RequestProcessor
    implements Runnable,
    SecureMessageCallback {
        private final RequestMessage request;

        private RequestProcessor(RequestMessage request) {
            this.request = request;
        }

        public void handleSecureMessage(SecureMessage sm, boolean passed) {
            if (passed) {
                MessageDispatcher.this.process(this);
            } else if (LOG.isErrorEnabled()) {
                LOG.error(this.request.getContact() + " send us a secure request Message but the signatures do not match!");
            }
        }

        public void run() {
            if (!MessageDispatcher.this.allow(this.request)) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace(this.request.getContact() + " refused");
                }
                MessageDispatcher.this.fireMessageFiltered(this.request);
                return;
            }
            AbstractRequestHandler requestHandler = null;
            if (this.request instanceof PingRequest) {
                requestHandler = MessageDispatcher.this.pingHandler;
            } else if (this.request instanceof FindNodeRequest) {
                requestHandler = MessageDispatcher.this.findNodeHandler;
            } else if (this.request instanceof FindValueRequest) {
                requestHandler = MessageDispatcher.this.findValueHandler;
            } else if (this.request instanceof StoreRequest) {
                requestHandler = MessageDispatcher.this.storeHandler;
            } else if (this.request instanceof StatsRequest) {
                requestHandler = MessageDispatcher.this.statsHandler;
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("There is no handler for " + this.request);
            }
            if (requestHandler != null) {
                try {
                    requestHandler.handleRequest(this.request);
                    MessageDispatcher.this.defaultHandler.handleRequest(this.request);
                }
                catch (IOException e) {
                    LOG.error("An exception occured during processing the request", e);
                }
            }
        }
    }

    private class ResponseProcessor
    implements Runnable,
    SecureMessageCallback {
        private final Tag.Receipt receipt;
        private final ResponseMessage response;

        private ResponseProcessor(Tag.Receipt receipt, ResponseMessage response) {
            this.receipt = receipt;
            this.response = response;
        }

        public void handleSecureMessage(SecureMessage sm, boolean passed) {
            if (passed) {
                MessageDispatcher.this.process(this);
            } else if (LOG.isErrorEnabled()) {
                LOG.error(this.response.getContact() + " send us a secure response Message but the signatures do not match!");
            }
        }

        public void run() {
            if (this.receipt != null) {
                this.processResponse();
            } else {
                this.processLateResponse();
            }
        }

        private void processResponse() {
            try {
                MessageDispatcher.this.defaultHandler.handleResponse(this.response, this.receipt.time());
                this.receipt.getResponseHandler().handleResponse(this.response, this.receipt.time());
            }
            catch (IOException e) {
                this.receipt.handleError(e);
                LOG.error("An error occured dusring processing the response", e);
            }
        }

        private void processLateResponse() {
            Contact node = this.response.getContact();
            if (LOG.isTraceEnabled()) {
                if (this.response instanceof PingResponse) {
                    LOG.trace("Received a late Pong from " + node);
                } else if (this.response instanceof FindNodeResponse) {
                    LOG.trace("Received a late FindNode response from " + node);
                } else if (this.response instanceof FindValueResponse) {
                    LOG.trace("Received a late FindValue response from " + node);
                } else if (this.response instanceof StoreResponse) {
                    LOG.trace("Received a late Store response from " + node);
                } else if (this.response instanceof StatsResponse) {
                    LOG.trace("Received a late Stats response from " + node);
                }
            }
            MessageDispatcher.this.fireLateResponse(this.response);
            MessageDispatcher.this.defaultHandler.handleLateResponse(this.response);
        }
    }

    private class CleanupProcessor
    implements Runnable {
        private CleanupProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ReceiptMap receiptMap = MessageDispatcher.this.receiptMap;
            synchronized (receiptMap) {
                MessageDispatcher.this.receiptMap.cleanup();
            }
        }
    }

    private class RegisterProcessor
    implements Runnable {
        private final Tag.Receipt receipt;

        private RegisterProcessor(Tag.Receipt receipt) {
            this.receipt = receipt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ReceiptMap receiptMap = MessageDispatcher.this.receiptMap;
            synchronized (receiptMap) {
                MessageDispatcher.this.receiptMap.add(this.receipt);
            }
        }
    }

    private class SubmitProcessor
    implements Runnable {
        private final Tag tag;

        private SubmitProcessor(Tag tag) {
            this.tag = tag;
        }

        public void run() {
            MessageDispatcher.this.submit(this.tag);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReceiptMap
    extends FixedSizeHashMap<MessageID, Tag.Receipt> {
        public ReceiptMap(int maxSize) {
            super(maxSize);
        }

        public void add(Tag.Receipt receipt) {
            this.put(receipt.getMessageID(), receipt);
        }

        public void cleanup() {
            Iterator it = this.values().iterator();
            while (it.hasNext()) {
                Tag.Receipt receipt = (Tag.Receipt)it.next();
                if (receipt.isCancelled()) {
                    it.remove();
                    continue;
                }
                if (receipt.timeout()) {
                    receipt.received();
                    it.remove();
                    MessageDispatcher.this.process(new TimeoutProcessor(receipt, true));
                    continue;
                }
                MessageDispatcher.this.process(new TickProcessor(receipt));
            }
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<MessageID, Tag.Receipt> eldest) {
            Tag.Receipt receipt = eldest.getValue();
            boolean timeout = receipt.timeout();
            if (super.removeEldestEntry(eldest) || timeout) {
                receipt.received();
                MessageDispatcher.this.process(new TimeoutProcessor(receipt, timeout));
                return true;
            }
            return false;
        }
    }
}

