/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.io;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.limewire.io.NetworkUtils;
import org.limewire.mojito.KUID;
import org.limewire.mojito.StatusCode;
import org.limewire.mojito.db.DHTValue;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.db.DHTValueFactoryManager;
import org.limewire.mojito.db.DHTValueType;
import org.limewire.mojito.messages.DHTMessage;
import org.limewire.mojito.messages.MessageID;
import org.limewire.mojito.messages.StatsRequest;
import org.limewire.mojito.messages.StoreResponse;
import org.limewire.mojito.messages.impl.DefaultMessageID;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.ContactFactory;
import org.limewire.mojito.routing.Vendor;
import org.limewire.mojito.routing.Version;
import org.limewire.security.AddressSecurityToken;
import org.limewire.security.MACCalculatorRepositoryManager;
import org.limewire.security.SecurityToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageInputStream
extends DataInputStream {
    private final MACCalculatorRepositoryManager MACCalculatorRepositoryManager;

    public MessageInputStream(InputStream in, MACCalculatorRepositoryManager MACCalculatorRepositoryManager2) {
        super(in);
        this.MACCalculatorRepositoryManager = MACCalculatorRepositoryManager2;
    }

    public byte[] readBytes(int bytes) throws IOException {
        byte[] buf = new byte[bytes];
        this.readFully(buf);
        return buf;
    }

    public KUID readKUID() throws IOException {
        return KUID.createWithInputStream(this);
    }

    public MessageID readMessageID() throws IOException {
        return DefaultMessageID.createWithInputStream(this, this.MACCalculatorRepositoryManager);
    }

    public BigInteger readDHTSize() throws IOException {
        int length = this.readUnsignedByte();
        if (length > 20) {
            throw new IOException("Illegal length: " + length);
        }
        byte[] num = this.readBytes(length);
        return new BigInteger(1, num);
    }

    public DHTValueEntity readDHTValueEntity(Contact sender, DHTValueFactoryManager factoryManager) throws IOException {
        Contact creator = this.readContact();
        KUID primaryKey = this.readKUID();
        DHTValue value = this.readDHTValue(factoryManager);
        if (creator.getNodeID().equals(sender.getNodeID())) {
            creator = sender;
        }
        return DHTValueEntity.createFromRemote(creator, sender, primaryKey, value);
    }

    private DHTValue readDHTValue(DHTValueFactoryManager factoryManager) throws IOException {
        DHTValueType valueType = this.readValueType();
        Version version = this.readVersion();
        byte[] data = null;
        int length = this.readUnsignedShort();
        if (length > 0) {
            data = new byte[length];
            this.readFully(data);
        }
        return factoryManager.createDHTValue(valueType, version, data);
    }

    public List<DHTValueEntity> readDHTValueEntities(Contact sender, DHTValueFactoryManager factoryManager) throws IOException {
        int size = this.readUnsignedByte();
        if (size == 0) {
            return Collections.emptyList();
        }
        DHTValueEntity[] entities = new DHTValueEntity[size];
        for (int i = 0; i < entities.length; ++i) {
            entities[i] = this.readDHTValueEntity(sender, factoryManager);
        }
        return Arrays.asList(entities);
    }

    public Collection<KUID> readKUIDs() throws IOException {
        int size = this.readUnsignedByte();
        if (size == 0) {
            return Collections.emptySet();
        }
        KUID[] keys = new KUID[size];
        for (int i = 0; i < size; ++i) {
            keys[i] = this.readKUID();
        }
        return Arrays.asList(keys);
    }

    public byte[] readSignature() throws IOException {
        int length = this.readUnsignedByte();
        if (length == 0) {
            return null;
        }
        byte[] signature = new byte[length];
        this.readFully(signature, 0, signature.length);
        return signature;
    }

    public Contact readContact() throws IOException {
        Vendor vendor = this.readVendor();
        Version version = this.readVersion();
        KUID nodeId = this.readKUID();
        InetSocketAddress addr = this.readSocketAddress();
        if (addr == null) {
            throw new UnknownHostException("SocketAddress is " + addr);
        }
        return ContactFactory.createUnknownContact(vendor, version, nodeId, addr);
    }

    public Collection<Contact> readContacts() throws IOException {
        int size = this.readUnsignedByte();
        if (size == 0) {
            return Collections.emptyList();
        }
        Contact[] nodes = new Contact[size];
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = this.readContact();
        }
        return Arrays.asList(nodes);
    }

    public InetAddress readInetAddress() throws IOException {
        int length = this.readUnsignedByte();
        if (length == 0) {
            return null;
        }
        byte[] address = new byte[length];
        this.readFully(address);
        return InetAddress.getByAddress(address);
    }

    public int readPort() throws IOException {
        return this.readUnsignedShort();
    }

    public InetSocketAddress readSocketAddress() throws IOException {
        InetAddress addr = this.readInetAddress();
        if (addr == null || !NetworkUtils.isValidAddress(addr)) {
            return null;
        }
        int port = this.readPort();
        return new InetSocketAddress(addr, port);
    }

    public SecurityToken readSecurityToken() throws IOException {
        int length = this.readUnsignedByte();
        if (length == 0) {
            return null;
        }
        byte[] securityToken = new byte[length];
        this.readFully(securityToken, 0, securityToken.length);
        return new AddressSecurityToken(securityToken, this.MACCalculatorRepositoryManager);
    }

    public byte[] readStatistics() throws IOException {
        int length = this.readUnsignedShort();
        if (length == 0) {
            return null;
        }
        byte[] statistics = new byte[length];
        this.readFully(statistics);
        return statistics;
    }

    public DHTMessage.OpCode readOpCode() throws IOException {
        return DHTMessage.OpCode.valueOf(this.readUnsignedByte());
    }

    public StatsRequest.StatisticType readStatisticType() throws IOException {
        return StatsRequest.StatisticType.valueOf(this.readUnsignedByte());
    }

    public StatusCode readStatusCode() throws IOException {
        return StatusCode.valueOf(this.readUnsignedShort(), this.readDHTString());
    }

    private String readDHTString() throws IOException {
        int length = this.readUnsignedShort();
        if (length == 0) {
            return "";
        }
        byte[] b = new byte[length];
        this.readFully(b);
        return new String(b, "UTF-8");
    }

    public Collection<StoreResponse.StoreStatusCode> readStoreStatusCodes() throws IOException {
        int size = this.readUnsignedByte();
        if (size == 0) {
            return Collections.emptySet();
        }
        StoreResponse.StoreStatusCode[] status = new StoreResponse.StoreStatusCode[size];
        for (int i = 0; i < size; ++i) {
            KUID primaryKey = this.readKUID();
            KUID secondaryKey = this.readKUID();
            StatusCode statusCode = this.readStatusCode();
            status[i] = new StoreResponse.StoreStatusCode(primaryKey, secondaryKey, statusCode);
        }
        return Arrays.asList(status);
    }

    public DHTValueType readValueType() throws IOException {
        return DHTValueType.valueOf(this.readInt());
    }

    public Vendor readVendor() throws IOException {
        return Vendor.valueOf(this.readInt());
    }

    public Version readVersion() throws IOException {
        return Version.valueOf(this.readUnsignedShort());
    }
}

