/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.manager;

import java.net.SocketAddress;
import java.util.Set;
import org.limewire.mojito.Context;
import org.limewire.mojito.concurrent.DHTFuture;
import org.limewire.mojito.concurrent.DHTFutureTask;
import org.limewire.mojito.concurrent.DHTTask;
import org.limewire.mojito.manager.AbstractManager;
import org.limewire.mojito.manager.BootstrapProcess;
import org.limewire.mojito.result.BootstrapResult;
import org.limewire.mojito.routing.Contact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BootstrapManager
extends AbstractManager<BootstrapResult> {
    private BootstrapFuture future = null;
    private boolean bootstrapped = false;

    public BootstrapManager(Context context) {
        super(context);
    }

    public synchronized boolean isBootstrapped() {
        return this.bootstrapped;
    }

    public synchronized void setBootstrapped(boolean bootstrapped) {
        this.bootstrapped = bootstrapped;
    }

    public synchronized boolean isBootstrapping() {
        return this.future != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        BootstrapFuture f;
        BootstrapManager bootstrapManager = this;
        synchronized (bootstrapManager) {
            f = this.future;
            this.future = null;
        }
        if (f != null) {
            f.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DHTFuture<BootstrapResult> bootstrap(Contact node) {
        if (node == null) {
            throw new NullPointerException("Contact is null");
        }
        if (node.equals(this.context.getLocalNode())) {
            throw new IllegalArgumentException("Cannot bootstrap from local Node");
        }
        this.stop();
        BootstrapProcess process = new BootstrapProcess(this.context, this, node);
        BootstrapFuture future = new BootstrapFuture(process);
        BootstrapManager bootstrapManager = this;
        synchronized (bootstrapManager) {
            this.future = future;
        }
        this.context.getDHTExecutorService().execute(future);
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DHTFuture<BootstrapResult> bootstrap(Set<? extends SocketAddress> dst) {
        if (dst == null) {
            throw new NullPointerException("Set<SocketAddress> is null");
        }
        this.stop();
        BootstrapProcess process = new BootstrapProcess(this.context, this, dst);
        BootstrapFuture future = new BootstrapFuture(process);
        BootstrapManager bootstrapManager = this;
        synchronized (bootstrapManager) {
            this.future = future;
        }
        this.context.getDHTExecutorService().execute(future);
        return future;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BootstrapFuture
    extends DHTFutureTask<BootstrapResult> {
        public BootstrapFuture(DHTTask<BootstrapResult> task) {
            super(BootstrapManager.this.context, task);
        }

        @Override
        protected void done() {
            BootstrapManager.this.stop();
        }
    }
}

