/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.manager;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.OnewayExchanger;
import org.limewire.mojito.Context;
import org.limewire.mojito.EntityKey;
import org.limewire.mojito.KUID;
import org.limewire.mojito.concurrent.DHTTask;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.db.DHTValueType;
import org.limewire.mojito.exceptions.DHTBackendException;
import org.limewire.mojito.exceptions.DHTException;
import org.limewire.mojito.handler.ResponseHandler;
import org.limewire.mojito.handler.response.AbstractResponseHandler;
import org.limewire.mojito.handler.response.FindNodeResponseHandler;
import org.limewire.mojito.handler.response.FindValueResponseHandler;
import org.limewire.mojito.handler.response.LookupResponseHandler;
import org.limewire.mojito.handler.response.StoreResponseHandler;
import org.limewire.mojito.messages.FindNodeResponse;
import org.limewire.mojito.messages.RequestMessage;
import org.limewire.mojito.messages.ResponseMessage;
import org.limewire.mojito.messages.SecurityTokenProvider;
import org.limewire.mojito.result.LookupResult;
import org.limewire.mojito.result.Result;
import org.limewire.mojito.result.StoreResult;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.settings.LookupSettings;
import org.limewire.mojito.settings.StoreSettings;
import org.limewire.mojito.util.ContactUtils;
import org.limewire.mojito.util.ContactsScrubber;
import org.limewire.mojito.util.EntityUtils;
import org.limewire.mojito.util.EntryImpl;
import org.limewire.security.SecurityToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StoreProcess
implements DHTTask<StoreResult> {
    private static final Log LOG = LogFactory.getLog(StoreProcess.class);
    private final Context context;
    private final List<DHTTask<?>> tasks = new ArrayList();
    private boolean cancelled = false;
    private OnewayExchanger<StoreResult, ExecutionException> exchanger;
    private final KUID primaryKey;
    private final Map.Entry<? extends Contact, ? extends SecurityToken> node;
    private final Collection<? extends DHTValueEntity> entities;
    private final long waitOnLock;

    public StoreProcess(Context context, Collection<? extends DHTValueEntity> entities) {
        this(context, null, entities);
    }

    public StoreProcess(Context context, Map.Entry<? extends Contact, ? extends SecurityToken> node, Collection<? extends DHTValueEntity> entities) {
        this.context = context;
        this.entities = entities;
        this.node = node;
        if (node != null && node.getKey() == null) {
            throw new IllegalArgumentException("Contact is null");
        }
        if (entities.isEmpty()) {
            throw new IllegalArgumentException("No Values to store");
        }
        if (node == null) {
            this.primaryKey = EntityUtils.getPrimaryKey(entities);
            if (this.primaryKey == null) {
                throw new IllegalArgumentException("All DHTValues must have the same primary key");
            }
        } else {
            this.primaryKey = null;
        }
        this.waitOnLock = StoreSettings.getWaitOnLock(node != null);
    }

    @Override
    public long getWaitOnLockTimeout() {
        return this.waitOnLock;
    }

    @Override
    public void start(OnewayExchanger<StoreResult, ExecutionException> exchanger) {
        if (exchanger == null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Starting ResponseHandler without an OnewayExchanger");
            }
            exchanger = new OnewayExchanger(true);
        }
        this.exchanger = exchanger;
        if (this.node == null) {
            this.findNearestNodes();
        } else if (this.node.getValue() == null && StoreSettings.STORE_REQUIRES_SECURITY_TOKEN.getValue()) {
            this.doGetSecurityToken();
        } else {
            this.doStoreOnPath(Collections.singleton(this.node));
        }
    }

    private void findNearestNodes() {
        OnewayExchanger<LookupResult, ExecutionException> c = new OnewayExchanger<LookupResult, ExecutionException>(true){

            @Override
            public synchronized void setValue(LookupResult value) {
                super.setValue(value);
                StoreProcess.this.handleNearestNodes(value);
            }

            @Override
            public synchronized void setException(ExecutionException exception) {
                super.setException(exception);
                StoreProcess.this.exchanger.setException(exception);
            }
        };
        LookupResponseHandler<LookupResult> handler = this.createLookupResponseHandler();
        handler.setSelectAliveNodesOnly(true);
        this.start(handler, c);
    }

    private void handleNearestNodes(LookupResult value) {
        this.doStoreOnPath(value.getEntryPath());
    }

    private void doGetSecurityToken() {
        OnewayExchanger<GetSecurityTokenResult, ExecutionException> c = new OnewayExchanger<GetSecurityTokenResult, ExecutionException>(true){

            @Override
            public synchronized void setValue(GetSecurityTokenResult value) {
                super.setValue(value);
                StoreProcess.this.handleSecurityToken(value);
            }

            @Override
            public synchronized void setException(ExecutionException exception) {
                super.setException(exception);
                StoreProcess.this.exchanger.setException(exception);
            }
        };
        GetSecurityTokenHandler handler = new GetSecurityTokenHandler(this.context, this.node.getKey());
        this.start(handler, c);
    }

    private void handleSecurityToken(GetSecurityTokenResult result) {
        SecurityToken securityToken = result.getSecurityToken();
        if (securityToken == null) {
            this.exchanger.setException(new ExecutionException(new DHTException("Could not get SecurityToken from " + this.node)));
        } else {
            EntryImpl<Contact, SecurityToken> entry = new EntryImpl<Contact, SecurityToken>(this.node.getKey(), securityToken);
            this.doStoreOnPath(Collections.singleton(entry));
        }
    }

    private void doStoreOnPath(Collection<? extends Map.Entry<? extends Contact, ? extends SecurityToken>> path) {
        StoreResponseHandler handler = new StoreResponseHandler(this.context, path, this.entities);
        this.start(handler, this.exchanger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void start(DHTTask<T> task, OnewayExchanger<T, ExecutionException> c) {
        boolean doStart = false;
        List<DHTTask<?>> list = this.tasks;
        synchronized (list) {
            if (!this.cancelled) {
                this.tasks.add(task);
                doStart = true;
            }
        }
        if (doStart) {
            task.start(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        ArrayList copy = null;
        List<DHTTask<?>> list = this.tasks;
        synchronized (list) {
            if (!this.cancelled) {
                copy = new ArrayList(this.tasks);
                this.tasks.clear();
                this.cancelled = true;
            }
        }
        if (copy != null) {
            for (DHTTask dHTTask : copy) {
                dHTTask.cancel();
            }
        }
    }

    private LookupResponseHandler<LookupResult> createLookupResponseHandler() {
        LookupResponseHandler handler = null;
        if (LookupSettings.FIND_NODE_FOR_SECURITY_TOKEN.getValue()) {
            handler = new FindNodeResponseHandler(this.context, this.primaryKey);
        } else {
            EntityKey lookupKey = EntityKey.createEntityKey(this.primaryKey, DHTValueType.ANY);
            handler = new FindValueResponseHandler(this.context, lookupKey);
        }
        return handler;
    }

    private static class GetSecurityTokenResult
    implements Result {
        private final SecurityToken securityToken;

        public GetSecurityTokenResult(SecurityToken securityToken) {
            this.securityToken = securityToken;
        }

        public SecurityToken getSecurityToken() {
            return this.securityToken;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetSecurityTokenHandler
    extends AbstractResponseHandler<GetSecurityTokenResult> {
        private static final Log LOG = LogFactory.getLog(GetSecurityTokenHandler.class);
        private final Contact node;

        private GetSecurityTokenHandler(Context context, Contact node) {
            super(context);
            this.node = node;
        }

        @Override
        protected void start() throws DHTException {
            RequestMessage request = this.createLookupRequest();
            try {
                this.context.getMessageDispatcher().send(this.node, request, (ResponseHandler)this);
            }
            catch (IOException err) {
                throw new DHTException(err);
            }
        }

        private RequestMessage createLookupRequest() {
            if (LookupSettings.FIND_NODE_FOR_SECURITY_TOKEN.getValue()) {
                return this.context.getMessageHelper().createFindNodeRequest(this.node.getContactAddress(), this.node.getNodeID());
            }
            Set<KUID> noKeys = Collections.emptySet();
            return this.context.getMessageHelper().createFindValueRequest(this.node.getContactAddress(), this.node.getNodeID(), noKeys, DHTValueType.ANY);
        }

        @Override
        protected void response(ResponseMessage message, long time) throws IOException {
            if (message instanceof FindNodeResponse) {
                ContactsScrubber scrubber;
                FindNodeResponse response = (FindNodeResponse)message;
                Contact sender = response.getContact();
                Collection<? extends Contact> nodes = response.getNodes();
                if (!nodes.isEmpty() && (scrubber = ContactsScrubber.scrub(this.context, sender, nodes, LookupSettings.CONTACTS_SCRUBBER_REQUIRED_RATIO.getValue())).isValidResponse()) {
                    for (Contact node : scrubber.getScrubbed()) {
                        assert (!node.isAlive());
                        this.context.getRouteTable().add(node);
                    }
                }
            }
            SecurityToken securityToken = null;
            if (message instanceof SecurityTokenProvider) {
                securityToken = ((SecurityTokenProvider)((Object)message)).getSecurityToken();
            }
            this.setReturnValue(new GetSecurityTokenResult(securityToken));
        }

        @Override
        protected void timeout(KUID nodeId, SocketAddress dst, RequestMessage message, long time) throws IOException {
            this.fireTimeoutException(nodeId, dst, message, time);
        }

        @Override
        protected void error(KUID nodeId, SocketAddress dst, RequestMessage message, IOException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Getting the SecurityToken from " + ContactUtils.toString(nodeId, dst) + " failed", e);
            }
            this.setException(new DHTBackendException(nodeId, dst, message, e));
        }
    }
}

