/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.messages;

import java.math.BigInteger;
import java.net.SocketAddress;
import java.util.Collection;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.db.DHTValueType;
import org.limewire.mojito.messages.FindNodeRequest;
import org.limewire.mojito.messages.FindNodeResponse;
import org.limewire.mojito.messages.FindValueRequest;
import org.limewire.mojito.messages.FindValueResponse;
import org.limewire.mojito.messages.MessageFactory;
import org.limewire.mojito.messages.PingRequest;
import org.limewire.mojito.messages.PingResponse;
import org.limewire.mojito.messages.RequestMessage;
import org.limewire.mojito.messages.StatsRequest;
import org.limewire.mojito.messages.StatsResponse;
import org.limewire.mojito.messages.StoreRequest;
import org.limewire.mojito.messages.StoreResponse;
import org.limewire.mojito.messages.impl.DefaultMessageFactory;
import org.limewire.mojito.routing.Contact;
import org.limewire.security.SecurityToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageHelper {
    protected final Context context;
    private MessageFactory factory;

    public MessageHelper(Context context) {
        this.context = context;
        this.factory = new DefaultMessageFactory(context);
    }

    public void setMessageFactory(MessageFactory factory) {
        if (factory == null) {
            factory = new DefaultMessageFactory(this.context);
        }
        this.factory = factory;
    }

    public MessageFactory getMessageFactory() {
        return this.factory;
    }

    protected Contact getLocalNode() {
        return this.context.getLocalNode();
    }

    protected BigInteger getEstimatedSize() {
        return this.context.size();
    }

    public PingRequest createPingRequest(SocketAddress dst) {
        return this.factory.createPingRequest(this.getLocalNode(), dst);
    }

    public PingResponse createPingResponse(RequestMessage request, SocketAddress externalAddress) {
        if (this.context.getContactAddress().equals(externalAddress)) {
            throw new IllegalArgumentException("Cannot tell other Node that its external address is the same as yours!");
        }
        return this.factory.createPingResponse(this.getLocalNode(), request.getContact(), request.getMessageID(), externalAddress, this.getEstimatedSize());
    }

    public FindNodeRequest createFindNodeRequest(SocketAddress dst, KUID lookupId) {
        return this.factory.createFindNodeRequest(this.getLocalNode(), dst, lookupId);
    }

    public FindNodeResponse createFindNodeResponse(RequestMessage request, Collection<? extends Contact> nodes) {
        return this.factory.createFindNodeResponse(this.getLocalNode(), request.getContact(), request.getMessageID(), nodes);
    }

    public FindValueRequest createFindValueRequest(SocketAddress dst, KUID lookupId, Collection<KUID> keys, DHTValueType valueType) {
        return this.factory.createFindValueRequest(this.getLocalNode(), dst, lookupId, keys, valueType);
    }

    public FindValueResponse createFindValueResponse(RequestMessage request, float requestLoad, Collection<? extends DHTValueEntity> values, Collection<KUID> keys) {
        return this.factory.createFindValueResponse(this.getLocalNode(), request.getContact(), request.getMessageID(), requestLoad, values, keys);
    }

    public StoreRequest createStoreRequest(SocketAddress dst, SecurityToken securityToken, Collection<? extends DHTValueEntity> values) {
        return this.factory.createStoreRequest(this.getLocalNode(), dst, securityToken, values);
    }

    public StoreResponse createStoreResponse(RequestMessage request, Collection<StoreResponse.StoreStatusCode> status) {
        return this.factory.createStoreResponse(this.getLocalNode(), request.getContact(), request.getMessageID(), status);
    }

    public StatsRequest createStatsRequest(SocketAddress dst, StatsRequest.StatisticType request) {
        return this.factory.createStatsRequest(this.getLocalNode(), dst, request);
    }

    public StatsResponse createStatsResponse(RequestMessage request, byte[] statistics) {
        return this.factory.createStatsResponse(this.getLocalNode(), request.getContact(), request.getMessageID(), statistics);
    }
}

