/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.messages;

import org.limewire.mojito.messages.DHTSecureMessage;
import org.limewire.mojito.messages.MessageFormatException;
import org.limewire.mojito.messages.RequestMessage;

public interface StatsRequest
extends RequestMessage,
DHTSecureMessage {
    public StatisticType getType();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StatisticType {
        STATISTICS(1),
        DATABASE(2),
        ROUTETABLE(3);

        private int type;
        private static final StatisticType[] TYPES;

        private StatisticType(int type) {
            this.type = type;
        }

        public int toByte() {
            return this.type;
        }

        public String toString() {
            return this.name() + " (" + this.toByte() + ")";
        }

        public static StatisticType valueOf(int type) throws MessageFormatException {
            int index = type % TYPES.length;
            StatisticType t = TYPES[index];
            if (t.type == type) {
                return t;
            }
            throw new MessageFormatException("Unknown type: " + type);
        }

        static {
            StatisticType[] types = StatisticType.values();
            TYPES = new StatisticType[types.length];
            for (StatisticType t : types) {
                int index = t.type % TYPES.length;
                if (TYPES[index] != null) {
                    throw new IllegalStateException("Type collision: index=" + index + ", TYPE=" + (Object)((Object)TYPES[index]) + ", t=" + (Object)((Object)t));
                }
                StatisticType.TYPES[index] = t;
            }
        }
    }
}

