/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.messages;

import java.io.Serializable;
import java.util.Collection;
import org.limewire.mojito.KUID;
import org.limewire.mojito.StatusCode;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.messages.ResponseMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface StoreResponse
extends ResponseMessage {
    public static final StatusCode OK = StatusCode.valueOf(1, "OK");
    public static final StatusCode ERROR = StatusCode.valueOf(2, "ERROR");

    public Collection<StoreStatusCode> getStoreStatusCodes();

    public static final class StoreStatusCode
    implements Serializable {
        private static final long serialVersionUID = -3753019724686307068L;
        private final KUID primaryKey;
        private final KUID secondaryKey;
        private final StatusCode statusCode;

        public StoreStatusCode(DHTValueEntity entity, StatusCode statusCode) {
            this(entity.getPrimaryKey(), entity.getSecondaryKey(), statusCode);
        }

        public StoreStatusCode(KUID primaryKey, KUID secondaryKey, StatusCode statusCode) {
            this.primaryKey = primaryKey;
            this.secondaryKey = secondaryKey;
            this.statusCode = statusCode;
        }

        public boolean isFor(DHTValueEntity entity) {
            return this.primaryKey.equals(entity.getPrimaryKey()) && this.secondaryKey.equals(entity.getSecondaryKey());
        }

        public KUID getPrimaryKey() {
            return this.primaryKey;
        }

        public KUID getSecondaryKey() {
            return this.secondaryKey;
        }

        public StatusCode getStatusCode() {
            return this.statusCode;
        }

        public int hashCode() {
            return this.primaryKey.hashCode() ^ this.secondaryKey.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StoreStatusCode)) {
                return false;
            }
            StoreStatusCode other = (StoreStatusCode)o;
            return this.primaryKey.equals(other.primaryKey) && this.secondaryKey.equals(other.secondaryKey) && this.statusCode.equals(other.statusCode);
        }

        public String toString() {
            return "PrimaryKey=" + this.primaryKey + ", secondaryKey=" + this.secondaryKey + ", statusCode=" + this.statusCode;
        }
    }
}

