/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.messages.impl;

import java.io.IOException;
import java.net.SocketAddress;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.io.MessageInputStream;
import org.limewire.mojito.io.MessageOutputStream;
import org.limewire.mojito.messages.DHTMessage;
import org.limewire.mojito.messages.LookupRequest;
import org.limewire.mojito.messages.MessageID;
import org.limewire.mojito.messages.impl.AbstractRequestMessage;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.Version;

abstract class AbstractLookupRequest
extends AbstractRequestMessage
implements LookupRequest {
    protected final KUID lookupId;

    public AbstractLookupRequest(Context context, DHTMessage.OpCode opcode, Contact contact, MessageID messageId, Version msgVersion, KUID lookupId) {
        super(context, opcode, contact, messageId, msgVersion);
        this.lookupId = lookupId;
    }

    public AbstractLookupRequest(Context context, DHTMessage.OpCode opcode, SocketAddress src, MessageID messageId, Version msgVersion, MessageInputStream in) throws IOException {
        super(context, opcode, src, messageId, msgVersion, in);
        switch (opcode) {
            case FIND_NODE_REQUEST: 
            case FIND_VALUE_REQUEST: {
                this.lookupId = in.readKUID();
                break;
            }
            default: {
                throw new IOException("Unknown opcode for lookup request: " + (Object)((Object)opcode));
            }
        }
    }

    public KUID getLookupID() {
        return this.lookupId;
    }

    protected void writeBody(MessageOutputStream out) throws IOException {
        out.writeKUID(this.lookupId);
    }
}

