/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.messages.impl;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import org.limewire.io.ByteBufferInputStream;
import org.limewire.io.ByteBufferOutputStream;
import org.limewire.io.NetworkUtils;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.db.DHTValueType;
import org.limewire.mojito.io.MessageInputStream;
import org.limewire.mojito.messages.DHTMessage;
import org.limewire.mojito.messages.FindNodeRequest;
import org.limewire.mojito.messages.FindNodeResponse;
import org.limewire.mojito.messages.FindValueRequest;
import org.limewire.mojito.messages.FindValueResponse;
import org.limewire.mojito.messages.MessageFactory;
import org.limewire.mojito.messages.MessageFormatException;
import org.limewire.mojito.messages.MessageID;
import org.limewire.mojito.messages.PingRequest;
import org.limewire.mojito.messages.PingResponse;
import org.limewire.mojito.messages.StatsRequest;
import org.limewire.mojito.messages.StatsResponse;
import org.limewire.mojito.messages.StoreRequest;
import org.limewire.mojito.messages.StoreResponse;
import org.limewire.mojito.messages.impl.DefaultMessageID;
import org.limewire.mojito.messages.impl.FindNodeRequestImpl;
import org.limewire.mojito.messages.impl.FindNodeResponseImpl;
import org.limewire.mojito.messages.impl.FindValueRequestImpl;
import org.limewire.mojito.messages.impl.FindValueResponseImpl;
import org.limewire.mojito.messages.impl.PingRequestImpl;
import org.limewire.mojito.messages.impl.PingResponseImpl;
import org.limewire.mojito.messages.impl.StatsRequestImpl;
import org.limewire.mojito.messages.impl.StatsResponseImpl;
import org.limewire.mojito.messages.impl.StoreRequestImpl;
import org.limewire.mojito.messages.impl.StoreResponseImpl;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.Version;
import org.limewire.security.SecurityToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMessageFactory
implements MessageFactory {
    protected final Context context;

    public DefaultMessageFactory(Context context) {
        this.context = context;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DHTMessage createMessage(SocketAddress src, ByteBuffer ... data) throws MessageFormatException, IOException {
        FilterInputStream in = null;
        try {
            in = new MessageInputStream(new ByteBufferInputStream(data), this.context.getMACCalculatorRepositoryManager());
            MessageID messageId = ((MessageInputStream)in).readMessageID();
            int func = ((DataInputStream)in).readUnsignedByte();
            if (func != 68) {
                throw new MessageFormatException("Unknown function ID: " + func);
            }
            Version msgVersion = ((MessageInputStream)in).readVersion();
            in.skip(4L);
            DHTMessage.OpCode opcode = ((MessageInputStream)in).readOpCode();
            switch (opcode) {
                case PING_REQUEST: {
                    PingRequestImpl pingRequestImpl = new PingRequestImpl(this.context, src, messageId, msgVersion, (MessageInputStream)in);
                    return pingRequestImpl;
                }
                case PING_RESPONSE: {
                    PingResponseImpl pingResponseImpl = new PingResponseImpl(this.context, src, messageId, msgVersion, (MessageInputStream)in);
                    return pingResponseImpl;
                }
                case FIND_NODE_REQUEST: {
                    FindNodeRequestImpl findNodeRequestImpl = new FindNodeRequestImpl(this.context, src, messageId, msgVersion, (MessageInputStream)in);
                    return findNodeRequestImpl;
                }
                case FIND_NODE_RESPONSE: {
                    FindNodeResponseImpl findNodeResponseImpl = new FindNodeResponseImpl(this.context, src, messageId, msgVersion, (MessageInputStream)in);
                    return findNodeResponseImpl;
                }
                case FIND_VALUE_REQUEST: {
                    FindValueRequestImpl findValueRequestImpl = new FindValueRequestImpl(this.context, src, messageId, msgVersion, (MessageInputStream)in);
                    return findValueRequestImpl;
                }
                case FIND_VALUE_RESPONSE: {
                    FindValueResponseImpl findValueResponseImpl = new FindValueResponseImpl(this.context, src, messageId, msgVersion, (MessageInputStream)in);
                    return findValueResponseImpl;
                }
                case STORE_REQUEST: {
                    StoreRequestImpl storeRequestImpl = new StoreRequestImpl(this.context, src, messageId, msgVersion, (MessageInputStream)in);
                    return storeRequestImpl;
                }
                case STORE_RESPONSE: {
                    StoreResponseImpl storeResponseImpl = new StoreResponseImpl(this.context, src, messageId, msgVersion, (MessageInputStream)in);
                    return storeResponseImpl;
                }
                case STATS_REQUEST: {
                    StatsRequestImpl statsRequestImpl = new StatsRequestImpl(this.context, src, messageId, msgVersion, (MessageInputStream)in);
                    return statsRequestImpl;
                }
                case STATS_RESPONSE: {
                    StatsResponseImpl statsResponseImpl = new StatsResponseImpl(this.context, src, messageId, msgVersion, (MessageInputStream)in);
                    return statsResponseImpl;
                }
            }
            throw new IOException("Unhandled OpCode " + (Object)((Object)opcode));
        }
        catch (IllegalArgumentException err) {
            String msg = src != null ? src.toString() : null;
            throw new MessageFormatException(msg, err);
        }
        catch (IOException err) {
            String msg = src != null ? src.toString() : null;
            throw new MessageFormatException(msg, err);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    public SecurityToken createSecurityToken(Contact dst) {
        return this.context.getSecurityTokenHelper().createSecurityToken(dst);
    }

    @Override
    public MessageID createMessageID(SocketAddress dst) {
        if (!NetworkUtils.isValidSocketAddress(dst)) {
            throw new IllegalArgumentException(dst + " is an invalid SocketAddress");
        }
        return DefaultMessageID.createWithSocketAddress(dst, this.context.getMACCalculatorRepositoryManager());
    }

    @Override
    public ByteBuffer writeMessage(SocketAddress dst, DHTMessage message) throws IOException {
        ByteBufferOutputStream out = new ByteBufferOutputStream(640, true);
        message.write(out);
        out.close();
        return ((ByteBuffer)out.getBuffer().flip()).order(ByteOrder.BIG_ENDIAN);
    }

    @Override
    public FindNodeRequest createFindNodeRequest(Contact contact, SocketAddress dst, KUID lookupId) {
        return new FindNodeRequestImpl(this.context, contact, this.createMessageID(dst), lookupId);
    }

    @Override
    public FindNodeResponse createFindNodeResponse(Contact contact, Contact dst, MessageID messageId, Collection<? extends Contact> nodes) {
        return new FindNodeResponseImpl(this.context, contact, messageId, this.createSecurityToken(dst), nodes);
    }

    @Override
    public FindValueRequest createFindValueRequest(Contact contact, SocketAddress dst, KUID lookupId, Collection<KUID> keys, DHTValueType valueType) {
        return new FindValueRequestImpl(this.context, contact, this.createMessageID(dst), lookupId, keys, valueType);
    }

    @Override
    public FindValueResponse createFindValueResponse(Contact contact, Contact dst, MessageID messageId, float requestLoad, Collection<? extends DHTValueEntity> entities, Collection<KUID> secondaryKeys) {
        return new FindValueResponseImpl(this.context, contact, messageId, requestLoad, entities, secondaryKeys);
    }

    @Override
    public PingRequest createPingRequest(Contact contact, SocketAddress dst) {
        return new PingRequestImpl(this.context, contact, this.createMessageID(dst));
    }

    @Override
    public PingResponse createPingResponse(Contact contact, Contact dst, MessageID messageId, SocketAddress externalAddress, BigInteger estimatedSize) {
        return new PingResponseImpl(this.context, contact, messageId, externalAddress, estimatedSize);
    }

    @Override
    public StatsRequest createStatsRequest(Contact contact, SocketAddress dst, StatsRequest.StatisticType stats) {
        return new StatsRequestImpl(this.context, contact, this.createMessageID(dst), stats);
    }

    @Override
    public StatsResponse createStatsResponse(Contact contact, Contact dst, MessageID messageId, byte[] statistics) {
        return new StatsResponseImpl(this.context, contact, messageId, statistics);
    }

    @Override
    public StoreRequest createStoreRequest(Contact contact, SocketAddress dst, SecurityToken securityToken, Collection<? extends DHTValueEntity> values) {
        return new StoreRequestImpl(this.context, contact, this.createMessageID(dst), securityToken, values);
    }

    @Override
    public StoreResponse createStoreResponse(Contact contact, Contact dst, MessageID messageId, Collection<StoreResponse.StoreStatusCode> status) {
        return new StoreResponseImpl(this.context, contact, messageId, status);
    }
}

