/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.messages.impl;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.Collection;
import org.limewire.mojito.Context;
import org.limewire.mojito.io.MessageInputStream;
import org.limewire.mojito.io.MessageOutputStream;
import org.limewire.mojito.messages.DHTMessage;
import org.limewire.mojito.messages.FindNodeResponse;
import org.limewire.mojito.messages.MessageID;
import org.limewire.mojito.messages.SecurityTokenProvider;
import org.limewire.mojito.messages.impl.AbstractLookupResponse;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.Version;
import org.limewire.security.SecurityToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindNodeResponseImpl
extends AbstractLookupResponse
implements FindNodeResponse,
SecurityTokenProvider {
    private final SecurityToken securityToken;
    private final Collection<? extends Contact> nodes;

    public FindNodeResponseImpl(Context context, Contact contact, MessageID messageId, SecurityToken securityToken, Collection<? extends Contact> nodes) {
        super(context, DHTMessage.OpCode.FIND_NODE_RESPONSE, contact, messageId, Version.ZERO);
        this.securityToken = securityToken;
        this.nodes = nodes;
    }

    public FindNodeResponseImpl(Context context, SocketAddress src, MessageID messageId, Version msgVersion, MessageInputStream in) throws IOException {
        super(context, DHTMessage.OpCode.FIND_NODE_RESPONSE, src, messageId, msgVersion, in);
        this.securityToken = in.readSecurityToken();
        this.nodes = in.readContacts();
    }

    @Override
    public SecurityToken getSecurityToken() {
        return this.securityToken;
    }

    @Override
    public Collection<? extends Contact> getNodes() {
        return this.nodes;
    }

    @Override
    protected void writeBody(MessageOutputStream out) throws IOException {
        out.writeSecurityToken(this.securityToken);
        out.writeContacts(this.nodes);
    }

    public String toString() {
        return "FindNodeResponse: securityToken=" + this.securityToken + ", nodes=" + this.nodes + " from " + this.getContact();
    }
}

