/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.messages.impl;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.Collection;
import org.limewire.mojito.Context;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.io.MessageInputStream;
import org.limewire.mojito.io.MessageOutputStream;
import org.limewire.mojito.messages.DHTMessage;
import org.limewire.mojito.messages.MessageID;
import org.limewire.mojito.messages.StoreRequest;
import org.limewire.mojito.messages.impl.AbstractRequestMessage;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.Version;
import org.limewire.security.SecurityToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreRequestImpl
extends AbstractRequestMessage
implements StoreRequest {
    private final SecurityToken securityToken;
    private final Collection<? extends DHTValueEntity> values;

    public StoreRequestImpl(Context context, Contact contact, MessageID messageId, SecurityToken securityToken, Collection<? extends DHTValueEntity> values) {
        super(context, DHTMessage.OpCode.STORE_REQUEST, contact, messageId, Version.ZERO);
        this.securityToken = securityToken;
        this.values = values;
    }

    public StoreRequestImpl(Context context, SocketAddress src, MessageID messageId, Version msgVersion, MessageInputStream in) throws IOException {
        super(context, DHTMessage.OpCode.STORE_REQUEST, src, messageId, msgVersion, in);
        this.securityToken = in.readSecurityToken();
        this.values = in.readDHTValueEntities(this.getContact(), context.getDHTValueFactoryManager());
    }

    @Override
    public SecurityToken getSecurityToken() {
        return this.securityToken;
    }

    @Override
    public Collection<? extends DHTValueEntity> getDHTValueEntities() {
        return this.values;
    }

    @Override
    protected void writeBody(MessageOutputStream out) throws IOException {
        out.writeSecurityToken(this.securityToken);
        out.writeDHTValueEntities(this.values);
    }

    public String toString() {
        return "StoreRequest: " + this.values;
    }
}

