/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.result;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.limewire.mojito.KUID;
import org.limewire.mojito.result.LookupResult;
import org.limewire.mojito.routing.Contact;
import org.limewire.security.SecurityToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindNodeResult
extends LookupResult {
    private final Map<? extends Contact, ? extends SecurityToken> path;
    private final Collection<? extends Contact> collisions;
    private final Set<KUID> queried;
    private final long time;
    private final int hop;
    private final int routeTableFailureCount;

    public FindNodeResult(KUID lookupId, Map<? extends Contact, ? extends SecurityToken> path, Collection<? extends Contact> collisions, Set<KUID> queried, long time, int hop, int routeTableFailureCount) {
        super(lookupId);
        this.path = path;
        this.collisions = new CopyOnWriteArrayList<Contact>(collisions);
        this.queried = new CopyOnWriteArraySet<KUID>(queried);
        this.time = time;
        this.hop = hop;
        this.routeTableFailureCount = routeTableFailureCount;
    }

    @Override
    public Collection<? extends Contact> getPath() {
        return this.path.keySet();
    }

    @Override
    public SecurityToken getSecurityToken(Contact node) {
        return this.path.get(node);
    }

    @Override
    public Collection<? extends Map.Entry<? extends Contact, ? extends SecurityToken>> getEntryPath() {
        return this.path.entrySet();
    }

    public int getRouteTableFailureCount() {
        return this.routeTableFailureCount;
    }

    public Collection<? extends Contact> getCollisions() {
        return this.collisions;
    }

    public Set<KUID> getQueried() {
        return this.queried;
    }

    public long getTime() {
        return this.time;
    }

    public int getHop() {
        return this.hop;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getLookupID()).append(" (time=").append(this.time).append("ms, hop=").append(this.hop).append(")\n");
        int i = 0;
        for (Map.Entry<? extends Contact, ? extends SecurityToken> entry : this.path.entrySet()) {
            buffer.append(i++).append(": ").append(entry.getKey()).append(", token=").append(entry.getValue()).append("\n");
        }
        if (!this.collisions.isEmpty()) {
            buffer.append("Collisions:\n");
            i = 0;
            for (Contact contact : this.collisions) {
                buffer.append(i++).append(": ").append(contact).append("\n");
            }
        }
        return buffer.toString();
    }
}

