/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.routing.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.limewire.collection.PatriciaTrie;
import org.limewire.collection.Trie;
import org.limewire.collection.TrieUtils;
import org.limewire.mojito.KUID;
import org.limewire.mojito.routing.Bucket;
import org.limewire.mojito.routing.ClassfulNetworkCounter;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.RouteTable;
import org.limewire.mojito.settings.KademliaSettings;
import org.limewire.mojito.settings.RouteTableSettings;
import org.limewire.mojito.util.FixedSizeHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BucketNode
implements Bucket {
    private static final long serialVersionUID = -4116522147032657308L;
    private final RouteTable routeTable;
    private final KUID bucketId;
    private final int depth;
    private final PatriciaTrie<KUID, Contact> nodeTrie;
    private transient Map<KUID, Contact> cache;
    private transient ClassfulNetworkCounter counter;
    private long timeStamp = 0L;

    public BucketNode(RouteTable routeTable, KUID bucketId, int depth) {
        this.routeTable = routeTable;
        this.bucketId = bucketId;
        this.depth = depth;
        this.nodeTrie = new PatriciaTrie(KUID.KEY_ANALYZER);
        this.init();
    }

    private void init() {
        this.cache = Collections.emptyMap();
        this.counter = new ClassfulNetworkCounter(this);
    }

    void postInit() {
        for (Contact node : this.nodeTrie.values()) {
            this.counter.incrementAndGet(node);
        }
    }

    @Override
    public KUID getBucketID() {
        return this.bucketId;
    }

    public RouteTable getRouteTable() {
        return this.routeTable;
    }

    @Override
    public boolean isLocalNode(Contact node) {
        return this.routeTable.isLocalNode(node);
    }

    @Override
    public ClassfulNetworkCounter getClassfulNetworkCounter() {
        return this.counter;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public void touch() {
        this.timeStamp = System.currentTimeMillis();
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public void addActiveContact(Contact node) {
        this.checkNodeID(node);
        assert (!this.isActiveFull());
        Contact existing = this.nodeTrie.put(node.getNodeID(), node);
        assert (existing == null);
        if (node.isAlive()) {
            this.touch();
        }
        this.counter.incrementAndGet(node);
    }

    @Override
    public Contact addCachedContact(Contact node) {
        this.checkNodeID(node);
        if (this.cache == Collections.EMPTY_MAP) {
            int maxSize = RouteTableSettings.MAX_CACHE_SIZE.getValue();
            this.cache = new FixedSizeHashMap<KUID, Contact>(maxSize / 2, 0.75f, true, maxSize);
        }
        if (!this.isCacheFull()) {
            Contact existing = this.cache.put(node.getNodeID(), node);
            assert (existing == null);
        } else {
            Contact lrs = this.getLeastRecentlySeenCachedContact();
            if (!lrs.isAlive() || !lrs.hasBeenRecentlyAlive() && node.isAlive()) {
                Contact c = this.cache.remove(lrs.getNodeID());
                assert (c == lrs);
                this.cache.put(node.getNodeID(), node);
                return c;
            }
        }
        return null;
    }

    @Override
    public Contact updateContact(Contact node) {
        this.checkNodeID(node);
        KUID nodeId = node.getNodeID();
        if (this.containsActiveContact(nodeId)) {
            Contact current = this.nodeTrie.put(nodeId, node);
            assert (current != null);
            this.counter.decrementAndGet(current);
            this.counter.incrementAndGet(node);
            return current;
        }
        if (this.containsCachedContact(nodeId)) {
            return this.cache.put(nodeId, node);
        }
        throw new IllegalStateException(node + " is not in this Bucket " + this.toString());
    }

    private void checkNodeID(Contact node) {
        if (this.depth <= 0) {
            return;
        }
        int bitIndex = this.bucketId.bitIndex(node.getNodeID());
        if (bitIndex < 0) {
            return;
        }
        assert (bitIndex >= this.depth) : "Wrong Bucket";
    }

    @Override
    public Contact get(KUID nodeId) {
        Contact node = this.getActiveContact(nodeId);
        if (node == null) {
            node = this.getCachedContact(nodeId);
        }
        return node;
    }

    @Override
    public Contact getActiveContact(KUID nodeId) {
        return this.nodeTrie.get(nodeId);
    }

    @Override
    public Contact getCachedContact(KUID nodeId) {
        return this.cache.get(nodeId);
    }

    @Override
    public Contact select(KUID nodeId) {
        return this.nodeTrie.select(nodeId);
    }

    @Override
    public Collection<Contact> select(KUID nodeId, int count) {
        return TrieUtils.select(this.nodeTrie, nodeId, count);
    }

    @Override
    public boolean remove(KUID nodeId) {
        if (this.removeActiveContact(nodeId)) {
            return true;
        }
        return this.removeCachedContact(nodeId);
    }

    @Override
    public boolean removeActiveContact(KUID nodeId) {
        Contact node = this.nodeTrie.remove(nodeId);
        if (node != null) {
            int old = this.counter.get(node);
            int now = this.counter.decrementAndGet(node);
            assert (now < old) : now + " < " + old + ", " + nodeId + ", " + node + this;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeCachedContact(KUID nodeId) {
        if (this.cache.remove(nodeId) != null) {
            if (this.cache.isEmpty()) {
                this.cache = Collections.emptyMap();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(KUID nodeId) {
        if (this.containsActiveContact(nodeId)) {
            return true;
        }
        return this.containsCachedContact(nodeId);
    }

    @Override
    public boolean containsActiveContact(KUID nodeId) {
        return this.nodeTrie.containsKey(nodeId);
    }

    @Override
    public boolean containsCachedContact(KUID nodeId) {
        return this.cache.containsKey(nodeId);
    }

    @Override
    public boolean isActiveFull() {
        return this.nodeTrie.size() >= this.getMaxActiveSize();
    }

    @Override
    public boolean isCacheFull() {
        return !this.cache.isEmpty() && ((FixedSizeHashMap)this.cache).isFull();
    }

    @Override
    public boolean isTooDeep() {
        return this.depth % RouteTableSettings.DEPTH_LIMIT.getValue() == 0;
    }

    @Override
    public Collection<Contact> getActiveContacts() {
        return this.nodeTrie.values();
    }

    @Override
    public Collection<Contact> getCachedContacts() {
        return this.cache.values();
    }

    @Override
    public Contact getLeastRecentlySeenActiveContact() {
        final Contact[] leastRecentlySeen = new Contact[]{null};
        this.nodeTrie.traverse(new Trie.Cursor<KUID, Contact>(){

            @Override
            public Trie.Cursor.SelectStatus select(Map.Entry<? extends KUID, ? extends Contact> entry) {
                Contact node = entry.getValue();
                Contact lrs = leastRecentlySeen[0];
                if (lrs == null || node.getTimeStamp() < lrs.getTimeStamp()) {
                    leastRecentlySeen[0] = node;
                }
                return Trie.Cursor.SelectStatus.CONTINUE;
            }
        });
        return leastRecentlySeen[0];
    }

    @Override
    public Contact getMostRecentlySeenActiveContact() {
        final Contact[] mostRecentlySeen = new Contact[]{null};
        this.nodeTrie.traverse(new Trie.Cursor<KUID, Contact>(){

            @Override
            public Trie.Cursor.SelectStatus select(Map.Entry<? extends KUID, ? extends Contact> entry) {
                Contact node = entry.getValue();
                Contact mrs = mostRecentlySeen[0];
                if (mrs == null || node.getTimeStamp() > mrs.getTimeStamp()) {
                    mostRecentlySeen[0] = node;
                }
                return Trie.Cursor.SelectStatus.CONTINUE;
            }
        });
        return mostRecentlySeen[0];
    }

    @Override
    public void purge() {
        Iterator<Contact> it = this.nodeTrie.values().iterator();
        while (it.hasNext()) {
            Contact node = it.next();
            if (node.isAlive() || this.isLocalNode(node)) continue;
            it.remove();
        }
        if (!this.isActiveFull() && !this.cache.isEmpty()) {
            ArrayList<Contact> contacts = new ArrayList<Contact>(this.getCachedContacts());
            for (int i = contacts.size() - 1; i >= 0 && !this.isActiveFull(); --i) {
                Contact node = (Contact)contacts.get(i);
                if (node.isAlive()) {
                    this.nodeTrie.put(node.getNodeID(), node);
                }
                boolean removed = this.removeCachedContact(node.getNodeID());
                assert (removed);
            }
        }
    }

    @Override
    public Contact getLeastRecentlySeenCachedContact() {
        if (this.getCachedContacts().isEmpty()) {
            return null;
        }
        return this.getCachedContacts().iterator().next();
    }

    @Override
    public Contact getMostRecentlySeenCachedContact() {
        Contact node = null;
        Iterator<Contact> i$ = this.getCachedContacts().iterator();
        while (i$.hasNext()) {
            Contact n;
            node = n = i$.next();
        }
        return node;
    }

    @Override
    public List<Bucket> split() {
        assert (this.getCachedContacts().isEmpty());
        BucketNode left = new BucketNode(this.routeTable, this.bucketId, this.depth + 1);
        BucketNode right = new BucketNode(this.routeTable, this.bucketId.set(this.depth), this.depth + 1);
        for (Contact node : this.getActiveContacts()) {
            KUID nodeId = node.getNodeID();
            if (!nodeId.isBitSet(this.depth)) {
                left.addActiveContact(node);
                continue;
            }
            right.addActiveContact(node);
        }
        assert (left.size() + right.size() == this.size());
        return Arrays.asList(left, right);
    }

    @Override
    public int size() {
        return this.getActiveSize() + this.getCacheSize();
    }

    @Override
    public int getActiveSize() {
        return this.nodeTrie.size();
    }

    @Override
    public int getMaxActiveSize() {
        return KademliaSettings.REPLICATION_PARAMETER.getValue();
    }

    @Override
    public int getCacheSize() {
        return this.cache.size();
    }

    @Override
    public boolean isRefreshRequired() {
        return System.currentTimeMillis() - this.getTimeStamp() >= RouteTableSettings.BUCKET_REFRESH_PERIOD.getValue();
    }

    @Override
    public void clear() {
        this.nodeTrie.clear();
        this.cache = Collections.emptyMap();
    }

    public int hashCode() {
        return this.bucketId.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof BucketNode)) {
            return false;
        }
        BucketNode other = (BucketNode)o;
        return this.bucketId.equals(other.bucketId) && this.depth == other.depth;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.bucketId).append(" (depth=").append(this.getDepth()).append(", active=").append(this.getActiveSize()).append(", cache=").append(this.getCacheSize()).append(")\n");
        Iterator<Contact> it = this.getActiveContacts().iterator();
        int i = 0;
        while (it.hasNext()) {
            buffer.append(" ").append(i).append(": ").append(it.next()).append("\n");
            ++i;
        }
        if (!this.getCachedContacts().isEmpty()) {
            buffer.append("---\n");
            it = this.getCachedContacts().iterator();
            i = 0;
            while (it.hasNext()) {
                buffer.append(" ").append(i).append(": ").append(it.next()).append("\n");
                ++i;
            }
        }
        return buffer.toString();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }
}

