/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.routing.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.mojito.KUID;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.Vendor;
import org.limewire.mojito.routing.Version;
import org.limewire.mojito.routing.impl.LocalContact;
import org.limewire.mojito.settings.NetworkSettings;
import org.limewire.mojito.settings.RouteTableSettings;
import org.limewire.mojito.util.ContactUtils;

public class RemoteContact
implements Contact {
    private static final long serialVersionUID = 833079992601013124L;
    private static final Log LOG = LogFactory.getLog(RemoteContact.class);
    private final KUID nodeId;
    private final Vendor vendor;
    private final Version version;
    private final int instanceId;
    private volatile transient SocketAddress sourceAddress;
    private volatile SocketAddress contactAddress;
    private transient long rtt = -1L;
    private volatile long timeStamp = 0L;
    private volatile long lastFailedTime = 0L;
    private volatile int failures = 0;
    private volatile transient Contact.State state = Contact.State.UNKNOWN;
    private volatile int flags = 0;

    public RemoteContact(SocketAddress sourceAddress, Vendor vendor, Version version, KUID nodeId, SocketAddress contactAddress, int instanceId, int flags, Contact.State state) {
        if (nodeId == null) {
            throw new NullPointerException("Node ID is null");
        }
        if (contactAddress == null) {
            throw new NullPointerException("SocketAddress is null");
        }
        this.sourceAddress = sourceAddress;
        this.vendor = vendor;
        this.version = version;
        this.nodeId = nodeId;
        this.contactAddress = contactAddress;
        this.instanceId = instanceId;
        this.flags = flags;
        Contact.State state2 = this.state = state != null ? state : Contact.State.UNKNOWN;
        if (Contact.State.ALIVE.equals((Object)state) || Contact.State.UNKNOWN.equals((Object)state) && sourceAddress != null) {
            this.timeStamp = System.currentTimeMillis();
            this.fixSourceAndContactAddress(sourceAddress);
        }
        this.checkPortConsistent();
    }

    private void checkPortConsistent() {
        int port = ((InetSocketAddress)this.contactAddress).getPort();
        if (port == 0) {
            this.setFirewalled(true);
        }
    }

    private void init() {
        this.sourceAddress = null;
        this.rtt = -1L;
        this.state = Contact.State.UNKNOWN;
    }

    public final void fixSourceAndContactAddress(SocketAddress sourceAddress) {
        if (sourceAddress != null) {
            this.sourceAddress = sourceAddress;
            SocketAddress backup = this.contactAddress;
            int port = ((InetSocketAddress)this.contactAddress).getPort();
            if (port == 0) {
                if (!this.isFirewalled() && LOG.isWarnEnabled()) {
                    LOG.warn(ContactUtils.toString(this.nodeId, sourceAddress) + " contact address is set to Port 0 but it is not marked as firewalled");
                }
                this.contactAddress = sourceAddress;
                this.checkPortConsistent();
            } else if (!NetworkSettings.ACCEPT_FORCED_ADDRESS.getValue() && !ContactUtils.isPrivateAddress(sourceAddress)) {
                this.contactAddress = new InetSocketAddress(((InetSocketAddress)sourceAddress).getAddress(), port);
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("Merged " + sourceAddress + " and " + backup + " to " + this.contactAddress + ", firewalled=" + this.isFirewalled());
            }
        }
    }

    public void updateWithExistingContact(Contact existing) {
        if (!this.nodeId.equals(existing.getNodeID())) {
            throw new IllegalArgumentException("Node IDs do not match: " + this + " vs. " + existing);
        }
        if (this.rtt < 0L) {
            this.rtt = existing.getRoundTripTime();
        }
        if (!this.isAlive() || this.getTimeStamp() < existing.getTimeStamp()) {
            this.timeStamp = existing.getTimeStamp();
            this.lastFailedTime = existing.getLastFailedTime();
            this.failures = existing.getFailures();
        }
    }

    public Vendor getVendor() {
        return this.vendor;
    }

    public Version getVersion() {
        return this.version;
    }

    public KUID getNodeID() {
        return this.nodeId;
    }

    public int getInstanceID() {
        return this.instanceId;
    }

    public int getFlags() {
        return this.flags;
    }

    public SocketAddress getContactAddress() {
        return this.contactAddress;
    }

    public SocketAddress getSourceAddress() {
        return this.sourceAddress;
    }

    public long getRoundTripTime() {
        return this.rtt;
    }

    public void setRoundTripTime(long rtt) {
        this.rtt = rtt;
    }

    public void setTimeStamp(long timeStamp) {
        assert (timeStamp != Long.MAX_VALUE);
        this.timeStamp = timeStamp;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public long getLastFailedTime() {
        return this.lastFailedTime;
    }

    public boolean isFirewalled() {
        return (this.flags & 1) != 0;
    }

    private void setFirewalled(boolean firewalled) {
        if (this.isFirewalled() != firewalled) {
            this.flags ^= 1;
        }
    }

    public long getAdaptativeTimeout() {
        long timeout = NetworkSettings.DEFAULT_TIMEOUT.getValue();
        if (this.rtt <= 0L || !this.isAlive()) {
            return timeout;
        }
        long rttFactor = NetworkSettings.MIN_TIMEOUT_RTT_FACTOR.getValue();
        long adaptiveTimeout = rttFactor * this.rtt + (long)this.failures * this.rtt;
        return Math.max(Math.min(timeout, adaptiveTimeout), NetworkSettings.MIN_TIMEOUT_RTT.getValue());
    }

    public void alive() {
        this.state = Contact.State.ALIVE;
        this.failures = 0;
        this.timeStamp = System.currentTimeMillis();
    }

    public boolean isAlive() {
        return Contact.State.ALIVE.equals((Object)this.state);
    }

    public void unknown() {
        this.state = Contact.State.UNKNOWN;
        this.failures = 0;
        this.timeStamp = 0L;
    }

    public boolean isUnknown() {
        return Contact.State.UNKNOWN.equals((Object)this.state);
    }

    public boolean isDead() {
        return Contact.State.DEAD.equals((Object)this.state);
    }

    public boolean hasBeenRecentlyAlive() {
        return System.currentTimeMillis() - this.getTimeStamp() < RouteTableSettings.MIN_RECONNECTION_TIME.getValue();
    }

    public int getFailures() {
        return this.failures;
    }

    public void handleFailure() {
        ++this.failures;
        this.lastFailedTime = System.currentTimeMillis();
        if (!this.isShutdown()) {
            if (this.getTimeStamp() > 0L) {
                if (this.failures >= RouteTableSettings.MAX_ALIVE_NODE_FAILURES.getValue()) {
                    this.state = Contact.State.DEAD;
                }
            } else if (this.failures >= RouteTableSettings.MAX_UNKNOWN_NODE_FAILURES.getValue()) {
                this.state = Contact.State.DEAD;
            }
        }
    }

    public boolean hasFailed() {
        return this.failures > 0;
    }

    public Contact.State getState() {
        return this.state;
    }

    public void setState(Contact.State state) {
        if (state == null) {
            state = Contact.State.UNKNOWN;
        }
        this.state = state;
    }

    public boolean isShutdown() {
        return (this.flags & 2) != 0;
    }

    public void shutdown(boolean shutdown) {
        if (this.isShutdown() != shutdown) {
            this.flags ^= 2;
            this.state = Contact.State.DEAD;
        }
    }

    public int hashCode() {
        return this.nodeId.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Contact) || o instanceof LocalContact) {
            return false;
        }
        Contact c = (Contact)o;
        return this.nodeId.equals(c.getNodeID()) && this.contactAddress.equals(c.getContactAddress());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(ContactUtils.toString(this.getNodeID(), this.getContactAddress())).append(", rtt=").append(this.getRoundTripTime()).append(", failures=").append(this.getFailures()).append(", instanceId=").append(this.getInstanceID()).append(", state=").append(this.isShutdown() ? "DOWN" : this.getState()).append(", firewalled=").append(this.isFirewalled());
        return buffer.toString();
    }
}

