/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.statistics;

import java.io.IOException;
import java.io.Writer;
import org.limewire.mojito.KUID;
import org.limewire.mojito.io.MessageDispatcher;
import org.limewire.mojito.statistics.SimpleStatistic;
import org.limewire.mojito.statistics.StatisticContainer;
import org.limewire.statistic.AbstractStatistic;
import org.limewire.statistic.Statistic;

public class NetworkStatisticContainer
extends StatisticContainer {
    public Statistic SENT_MESSAGES_COUNT = new SimpleStatistic();
    public Statistic SENT_MESSAGES_SIZE = new SizeStatistic();
    public Statistic RECEIVED_MESSAGES_COUNT = new SimpleStatistic();
    public Statistic RECEIVED_MESSAGES_SIZE = new SizeStatistic();
    public Statistic LATE_MESSAGES_COUNT = new SimpleStatistic();
    public Statistic PINGS_SENT = new SimpleStatistic();
    public Statistic PINGS_OK = new SimpleStatistic();
    public Statistic PINGS_FAILED = new SimpleStatistic();
    public Statistic PING_REQUESTS = new SimpleStatistic();
    public Statistic STATS_REQUEST = new SimpleStatistic();
    public Statistic PONGS_SENT = new SimpleStatistic();
    public Statistic SIGNED_PONGS_SENT = new SimpleStatistic();
    public Statistic FILTERED_MESSAGES = new SimpleStatistic();
    public Statistic RECEIPTS_TIMEOUT = new SimpleStatistic();
    public Statistic RECEIPTS_EVICTED = new SimpleStatistic();
    public Statistic BOOTSTRAP_TIME = new SimpleStatistic();
    public Statistic BOOTSTRAP_PING_FAILURES = new SimpleStatistic();
    public Statistic ESTIMATE_SIZE = new SizeStatistic();
    public Statistic STORE_REQUESTS = new SizeStatistic();
    public Statistic STORE_REQUESTS_NO_QK = new SizeStatistic();
    public Statistic STORE_REQUESTS_BAD_QK = new SizeStatistic();
    public Statistic STORE_REQUESTS_OK = new SizeStatistic();
    public Statistic STORE_REQUESTS_FAILURE = new SizeStatistic();
    public Statistic FIND_VALUE_REQUESTS = new SimpleStatistic();
    public Statistic LOOKUP_REQUESTS = new SimpleStatistic();

    public NetworkStatisticContainer(KUID nodeId) {
        super(nodeId);
    }

    public void writeStats(Writer writer) throws IOException {
        writer.write("Network Stats:\n");
        super.writeStats(writer);
    }

    public static class Listener
    implements MessageDispatcher.MessageDispatcherListener {
        private NetworkStatisticContainer networkStats;

        public Listener(NetworkStatisticContainer networkStats) {
            this.networkStats = networkStats;
        }

        public void handleMessageDispatcherEvent(MessageDispatcher.MessageDispatcherEvent evt) {
            MessageDispatcher.MessageDispatcherEvent.EventType type = evt.getEventType();
            if (type.equals((Object)MessageDispatcher.MessageDispatcherEvent.EventType.MESSAGE_SENT)) {
                this.networkStats.SENT_MESSAGES_COUNT.incrementStat();
            } else if (type.equals((Object)MessageDispatcher.MessageDispatcherEvent.EventType.MESSAGE_RECEIVED)) {
                this.networkStats.RECEIVED_MESSAGES_COUNT.incrementStat();
            } else if (type.equals((Object)MessageDispatcher.MessageDispatcherEvent.EventType.LATE_RESPONSE)) {
                this.networkStats.LATE_MESSAGES_COUNT.incrementStat();
            } else if (type.equals((Object)MessageDispatcher.MessageDispatcherEvent.EventType.MESSAGE_FILTERED)) {
                this.networkStats.FILTERED_MESSAGES.incrementStat();
            } else if (type.equals((Object)MessageDispatcher.MessageDispatcherEvent.EventType.RECEIPT_TIMEOUT)) {
                this.networkStats.RECEIPTS_TIMEOUT.incrementStat();
            } else if (type.equals((Object)MessageDispatcher.MessageDispatcherEvent.EventType.RECEIPT_EVICTED)) {
                this.networkStats.RECEIPTS_EVICTED.incrementStat();
            }
        }
    }

    protected static class SizeStatistic
    extends AbstractStatistic {
        protected SizeStatistic() {
        }

        public void addData(int data) {
            super.addData(data);
            super.storeCurrentStat();
        }
    }
}

