/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.util;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.limewire.mojito.settings.KademliaSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static <T> Set<T> toSet(Collection<T> c) {
        if (c instanceof Set) {
            return (Set)c;
        }
        return new LinkedHashSet<T>(c);
    }

    public static <T> List<T> toList(Collection<T> c) {
        if (c instanceof List) {
            return (List)c;
        }
        return new ArrayList<T>(c);
    }

    public static String toString(Collection<?> c) {
        StringBuilder buffer = new StringBuilder();
        Iterator<?> it = c.iterator();
        int i = 0;
        while (it.hasNext()) {
            buffer.append(i).append(": ").append(it.next()).append('\n');
            ++i;
        }
        if (buffer.length() > 1) {
            buffer.setLength(buffer.length() - 1);
        }
        return buffer.toString();
    }

    private static <T> Iterator<T> iterator(final Collection<T> c, final int count) {
        return new Iterator<T>(){
            private final Iterator<T> it;
            private int item;
            {
                this.it = c.iterator();
                this.item = 0;
            }

            @Override
            public boolean hasNext() {
                if (this.item >= count) {
                    return false;
                }
                return this.it.hasNext();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ++this.item;
                return this.it.next();
            }

            @Override
            public void remove() {
                this.it.remove();
                --this.item;
            }
        };
    }

    public static <T> Collection<T> getCollection(Collection<T> c) {
        return CollectionUtils.getCollection(c, KademliaSettings.REPLICATION_PARAMETER.getValue());
    }

    public static <T> Collection<T> getCollection(final Collection<T> c, final int count) {
        return new AbstractCollection<T>(){

            @Override
            public Iterator<T> iterator() {
                return CollectionUtils.iterator(c, count);
            }

            @Override
            public int size() {
                return Math.min(c.size(), count);
            }
        };
    }
}

