/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.util;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.limewire.mojito.KUID;
import org.limewire.mojito.MojitoDHT;
import org.limewire.mojito.MojitoFactory;
import org.limewire.mojito.concurrent.DHTFuture;
import org.limewire.mojito.result.BootstrapResult;
import org.limewire.mojito.result.PingResult;
import org.limewire.mojito.settings.KademliaSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MojitoUtils {
    private MojitoUtils() {
    }

    public static DHTFuture<BootstrapResult> bootstrap(MojitoDHT dht, SocketAddress addr) throws ExecutionException, InterruptedException {
        PingResult pong = (PingResult)dht.ping(addr).get();
        return dht.bootstrap(pong.getContact());
    }

    public static List<MojitoDHT> createBootStrappedDHTs(int factor) throws Exception {
        return MojitoUtils.createBootStrappedDHTs(factor, 3000);
    }

    public static List<MojitoDHT> createBootStrappedDHTs(int factor, int port) throws Exception {
        if (factor < 1) {
            throw new IllegalArgumentException("only values >= 1");
        }
        int k = KademliaSettings.REPLICATION_PARAMETER.getValue();
        ArrayList<MojitoDHT> dhts = new ArrayList<MojitoDHT>();
        for (int i = 0; i < factor * k; ++i) {
            MojitoDHT dht = MojitoFactory.createDHT("DHT-" + i);
            dht.bind(new InetSocketAddress(port + i));
            dht.start();
            if (i > 0) {
                dht.bootstrap(new InetSocketAddress("localhost", port)).get();
            }
            dhts.add(dht);
        }
        ((MojitoDHT)dhts.get(0)).bootstrap(((MojitoDHT)dhts.get(1)).getContactAddress()).get();
        return dhts;
    }

    public static Map<KUID, MojitoDHT> createBootStrappedDHTsMap(int factor) throws Exception {
        return MojitoUtils.createBootStrappedDHTsMap(factor, 3000);
    }

    public static Map<KUID, MojitoDHT> createBootStrappedDHTsMap(int factor, int port) throws Exception {
        if (factor < 1) {
            throw new IllegalArgumentException("only values >= 1");
        }
        int k = KademliaSettings.REPLICATION_PARAMETER.getValue();
        LinkedHashMap<KUID, MojitoDHT> dhts = new LinkedHashMap<KUID, MojitoDHT>();
        MojitoDHT first = null;
        for (int i = 0; i < factor * k; ++i) {
            MojitoDHT dht = MojitoFactory.createDHT("DHT-" + i);
            dht.bind(new InetSocketAddress(port + i));
            dht.start();
            if (i > 0) {
                dht.bootstrap(new InetSocketAddress("localhost", port)).get();
            } else {
                first = dht;
            }
            dhts.put(dht.getLocalNodeID(), dht);
        }
        if (first != null) {
            first.bootstrap(new InetSocketAddress("localhost", 3001)).get();
        }
        return dhts;
    }
}

