/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.limewire.mojito.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeAwareIterable<E>
implements Iterable<E> {
    private final int sampleSize;
    private final long maxTime;
    private final List<? extends E> elements;

    public TimeAwareIterable(long maxTime, Collection<? extends E> elements) {
        this(10, maxTime, elements);
    }

    public TimeAwareIterable(int sampleSize, long maxTime, Collection<? extends E> elements) {
        this.sampleSize = sampleSize;
        this.maxTime = maxTime;
        this.elements = CollectionUtils.toList(elements);
    }

    @Override
    public Iterator<E> iterator() {
        return new TimeAwareIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TimeAwareIterator
    implements Iterator<E> {
        private final long[] samples;
        private int sampleCount;
        private int sampleIndex;
        private long startTime;
        private long lastTime;
        private int currentIndex;
        private int nextIndex;

        private TimeAwareIterator() {
            this.samples = new long[TimeAwareIterable.this.sampleSize];
            this.sampleCount = 0;
            this.sampleIndex = 0;
            this.startTime = -1L;
            this.lastTime = -1L;
            this.currentIndex = -1;
            this.nextIndex = 0;
        }

        @Override
        public boolean hasNext() {
            if (this.currentIndex == -1 && this.nextIndex < TimeAwareIterable.this.elements.size()) {
                long currentTime = System.currentTimeMillis();
                long average = 0L;
                if (this.startTime == -1L) {
                    this.startTime = currentTime;
                }
                if (this.lastTime != -1L) {
                    average = this.addSample(currentTime - this.lastTime);
                }
                this.lastTime = currentTime;
                long timeRemaining = TimeAwareIterable.this.maxTime - (currentTime - this.startTime);
                if (timeRemaining >= average) {
                    this.currentIndex = this.nextIndex++;
                    int elementsRemaining = TimeAwareIterable.this.elements.size() - this.nextIndex;
                    assert (elementsRemaining >= 0);
                    this.nextIndex += (int)(average * (long)elementsRemaining / timeRemaining);
                }
            }
            return this.currentIndex != -1;
        }

        @Override
        public E next() {
            if (this.startTime == -1L || this.currentIndex == -1) {
                throw new NoSuchElementException();
            }
            int index = this.currentIndex;
            this.currentIndex = -1;
            return TimeAwareIterable.this.elements.get(index);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private long addSample(long time) {
            if (time >= 0L) {
                this.samples[this.sampleIndex] = time;
                this.sampleIndex = (this.sampleIndex + 1) % this.samples.length;
                if (this.sampleCount < this.samples.length) {
                    ++this.sampleCount;
                }
            }
            return this.getAverage();
        }

        private long getAverage() {
            if (this.sampleCount == 0) {
                return 0L;
            }
            long sum = 0L;
            for (long time : this.samples) {
                sum += time;
            }
            return sum / (long)this.sampleCount;
        }
    }
}

