/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.visual;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.limewire.mojito.KUID;
import org.limewire.mojito.io.MessageDispatcher;
import org.limewire.mojito.messages.DHTMessage;
import org.limewire.mojito.visual.Painter;

class DartBoard
extends Painter {
    private static final float DOT_SIZE = 6.0f;
    private static final long ATTACK = 250L;
    private static final long RELEASE = 2750L;
    private static final long DURATION = 3000L;
    private static final int RESOLUTION = 16;
    private final List<Node> nodes = new LinkedList<Node>();
    private final Ellipse2D.Double ellipse = new Ellipse2D.Double();
    private final Ellipse2D.Double dot = new Ellipse2D.Double();
    private final Point2D.Double localhost = new Point2D.Double();
    private final KUID nodeId;

    public DartBoard(KUID nodeId) {
        this.nodeId = nodeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Component c, Graphics2D g) {
        double arc_width;
        double width = c.getWidth();
        double height = c.getHeight();
        double gap = 50.0;
        double radius = Math.max(Math.min(width / 2.0, height / 2.0) - gap, gap);
        double arc_x = width / 2.0 - radius;
        double arc_y = height / 2.0 - radius;
        double arc_height = arc_width = 2.0 * radius;
        g.setColor(Color.orange);
        g.setStroke(TWO_PIXEL_STROKE);
        this.ellipse.setFrame(arc_x, arc_y, arc_width, arc_height);
        g.draw(this.ellipse);
        double dx = width / 2.0;
        double dy = height / 2.0;
        g.setColor(new Color(0, 255, 0, 80));
        g.setStroke(new BasicStroke(0.5f));
        for (int i = 0; i < 16; ++i) {
            int innerWidth = (int)(arc_width * (double)i / 16.0);
            int innerHeight = (int)(arc_height * (double)i / 16.0);
            g.drawOval((int)dx - innerWidth / 2, (int)dy - innerHeight / 2, innerWidth, innerHeight);
        }
        this.dot.setFrame(dx - 3.0, dy - 3.0, 6.0, 6.0);
        this.localhost.setLocation(dx, dy);
        List<Node> list = this.nodes;
        synchronized (list) {
            Iterator<Node> it = this.nodes.iterator();
            while (it.hasNext()) {
                if (!it.next().paint(this.localhost, width, height, radius, g)) continue;
                it.remove();
            }
        }
        g.setColor(Color.orange);
        g.setStroke(DEFAULT_STROKE);
        g.fill(this.dot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(MessageDispatcher.MessageDispatcherEvent.EventType type, KUID nodeId, SocketAddress dst, DHTMessage.OpCode opcode, boolean request) {
        if (nodeId == null) {
            return;
        }
        List<Node> list = this.nodes;
        synchronized (list) {
            this.nodes.add(new Node(type, nodeId.xor(this.nodeId), opcode, request));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<Node> list = this.nodes;
        synchronized (list) {
            this.nodes.clear();
        }
    }

    private static class Node {
        private final long timeStamp = System.currentTimeMillis();
        private final MessageDispatcher.MessageDispatcherEvent.EventType type;
        private final KUID nodeId;
        private final boolean request;
        private final Stroke stroke;
        private final Ellipse2D.Float ellipse = new Ellipse2D.Float();

        public Node(MessageDispatcher.MessageDispatcherEvent.EventType type, KUID nodeId, DHTMessage.OpCode opcode, boolean request) {
            this.type = type;
            this.nodeId = nodeId;
            this.request = request;
            this.stroke = Painter.getStrokeForOpCode(opcode);
        }

        private int alpha() {
            long delta = System.currentTimeMillis() - this.timeStamp;
            if (delta < 250L) {
                return (int)(1.02f * (float)delta);
            }
            return Math.max(255 - (int)(0.085f * (float)delta), 0);
        }

        private double size() {
            double r = 15.0;
            long delta = System.currentTimeMillis() - this.timeStamp;
            if (delta < 3000L) {
                return r / 3000.0 * (double)delta;
            }
            return r;
        }

        public boolean paint(Point2D.Double localhost, double width, double height, double radius, Graphics2D g) {
            int power = 0;
            int hexOffset = 4;
            String hex = this.nodeId.toHexString().substring(0, hexOffset);
            int intId = Integer.valueOf(hex, 16);
            assert (intId >= 0);
            while (intId > 0) {
                intId >>= 1;
                ++power;
            }
            power = Math.max(0, power - 1);
            assert (power <= 16);
            double distance = (double)power * radius / 16.0;
            BigInteger twoPower = BigInteger.ZERO.setBit(power + 160 - 16);
            BigDecimal angleBD = new BigDecimal(this.nodeId.toBigInteger().subtract(twoPower));
            angleBD = angleBD.divide(new BigDecimal(twoPower));
            double angle = angleBD.doubleValue() * 360.0;
            assert (angle <= 360.0);
            double x1 = localhost.x;
            double y1 = localhost.y;
            double x2 = x1 + Math.cos(angle) * distance;
            double y2 = y1 + Math.sin(angle) * distance;
            int red = 0;
            int green = 0;
            int blue = 0;
            if (this.type.equals((Object)MessageDispatcher.MessageDispatcherEvent.EventType.MESSAGE_SENT)) {
                red = 255;
                if (!this.request) {
                    blue = 255;
                }
            } else {
                green = 255;
                if (this.request) {
                    blue = 255;
                }
            }
            g.setColor(new Color(red, green, blue, this.alpha()));
            g.setStroke(this.stroke);
            double size = this.size();
            this.ellipse.setFrameFromCenter(x2, y2, x2 + size, y2 + size);
            g.draw(this.ellipse);
            return System.currentTimeMillis() - this.timeStamp >= 3000L;
        }
    }
}

