/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.visual;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.limewire.mojito.KUID;
import org.limewire.mojito.io.MessageDispatcher;
import org.limewire.mojito.messages.DHTMessage;
import org.limewire.mojito.visual.Painter;

class SnowMan
extends Painter {
    private static final long ATTACK = 250L;
    private static final long RELEASE = 2750L;
    private static final long DURATION = 3000L;
    private static final float DOT_SIZE = 6.0f;
    private final List<Node> nodes = new LinkedList<Node>();
    private final Ellipse2D.Double dot = new Ellipse2D.Double();
    private final Point2D.Double localhost = new Point2D.Double();
    private final KUID nodeId;

    public SnowMan(KUID nodeId) {
        this.nodeId = nodeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Component c, Graphics2D g2) {
        int width = c.getWidth();
        int height = c.getHeight();
        g2.setColor(Color.orange);
        g2.setStroke(new BasicStroke(2.0f));
        g2.draw(new Line2D.Float((float)width / 2.0f, 0.0f, (float)width / 2.0f, height));
        double x = (float)width / 2.0f;
        double y = SnowMan.position(this.nodeId, (double)height);
        this.localhost.setLocation(x, y);
        List<Node> list = this.nodes;
        synchronized (list) {
            Iterator<Node> it = this.nodes.iterator();
            while (it.hasNext()) {
                if (!it.next().paint(this.localhost, width, height, g2)) continue;
                it.remove();
            }
        }
        g2.setColor(Color.orange);
        this.dot.setFrame(x - 3.0, y - 3.0, 6.0, 6.0);
        g2.setStroke(DEFAULT_STROKE);
        g2.fill(this.dot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(MessageDispatcher.MessageDispatcherEvent.EventType type, KUID nodeId, SocketAddress dst, DHTMessage.OpCode opcode, boolean request) {
        if (nodeId == null) {
            return;
        }
        List<Node> list = this.nodes;
        synchronized (list) {
            this.nodes.add(new Node(this.dot, type, nodeId, opcode, request));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<Node> list = this.nodes;
        synchronized (list) {
            this.nodes.clear();
        }
    }

    private static class Node {
        private final Ellipse2D.Double dot;
        private final MessageDispatcher.MessageDispatcherEvent.EventType type;
        private final KUID nodeId;
        private final boolean request;
        private final long timeStamp = System.currentTimeMillis();
        private final Arc2D.Double arc = new Arc2D.Double();
        private final Ellipse2D.Double circle = new Ellipse2D.Double();
        private final Ellipse2D.Double prxDot = new Ellipse2D.Double();
        private final Stroke stroke;

        public Node(Ellipse2D.Double dot, MessageDispatcher.MessageDispatcherEvent.EventType type, KUID nodeId, DHTMessage.OpCode opcode, boolean request) {
            this.dot = dot;
            this.type = type;
            this.nodeId = nodeId;
            this.request = request;
            this.stroke = Painter.getStrokeForOpCode(opcode);
            if (nodeId == null) assert (request && type.equals((Object)MessageDispatcher.MessageDispatcherEvent.EventType.MESSAGE_SENT));
        }

        private int alpha() {
            long delta = System.currentTimeMillis() - this.timeStamp;
            if (delta < 3000L) {
                return 255 - (int)(0.085f * (float)delta);
            }
            return 0;
        }

        private double extent() {
            long delta = System.currentTimeMillis() - this.timeStamp;
            if (delta < 1000L) {
                return 0.18 * (double)delta;
            }
            return 180.0;
        }

        private double radius() {
            double r = 20.0;
            long delta = System.currentTimeMillis() - this.timeStamp;
            if (delta < 3000L) {
                return 0.006666666666666667 * (double)delta;
            }
            return 20.0;
        }

        public boolean paint(Point2D.Double localhost, double width, double height, Graphics2D g) {
            if (this.nodeId != null) {
                this.paintArc(localhost, width, height, g);
            } else {
                this.paintLine(localhost, width, height, g);
            }
            return System.currentTimeMillis() - this.timeStamp >= 3000L;
        }

        private void paintArc(Point2D.Double localhost, double width, double height, Graphics2D g) {
            double nodeX;
            double distance;
            double nodeY = Painter.position(this.nodeId, height);
            double bow = distance = Math.max(localhost.y, nodeY) - Math.min(localhost.y, nodeY);
            double arcX = nodeX = (width - bow) / 2.0;
            double arcY = localhost.y < nodeY ? nodeY - distance : nodeY;
            double start = 0.0;
            double extent = 0.0;
            int red = 0;
            int green = 0;
            int blue = 0;
            if (this.type.equals((Object)MessageDispatcher.MessageDispatcherEvent.EventType.MESSAGE_SENT)) {
                red = 255;
                if (!this.request) {
                    blue = 255;
                }
                if (localhost.y < nodeY) {
                    start = 90.0;
                    extent = -this.extent();
                } else {
                    start = -90.0;
                    extent = this.extent();
                }
            } else {
                green = 255;
                if (this.request) {
                    blue = 255;
                }
                if (localhost.y < nodeY) {
                    start = -90.0;
                    extent = -this.extent();
                } else {
                    start = 90.0;
                    extent = this.extent();
                }
            }
            Point2D.Double corner = new Point2D.Double(localhost.x + 2.0 * this.dot.width, localhost.y + 2.0 * this.dot.height);
            this.prxDot.setFrameFromCenter(localhost, corner);
            RectangularShape shape = null;
            if (!this.prxDot.contains(width / 2.0, nodeY)) {
                this.arc.setArc(arcX, arcY, bow, distance, start, extent, 0);
                shape = this.arc;
            } else {
                double r = this.radius();
                this.circle.setFrameFromCenter(localhost.x, localhost.y, localhost.x + r, localhost.y + r);
                shape = this.circle;
            }
            if (shape != null) {
                g.setStroke(this.stroke);
                g.setColor(new Color(red, green, blue, this.alpha()));
                g.draw(shape);
            }
        }

        private void paintLine(Point2D.Double localhost, double width, double height, Graphics2D g) {
            g.setStroke(Painter.DEFAULT_STROKE);
            g.setColor(new Color(255, 0, 0, this.alpha()));
            double x1 = localhost.x;
            double y1 = localhost.y;
            double x2 = x1 + width / 360.0 * this.extent();
            double y2 = y1;
            g.draw(new Line2D.Double(x1, y1, x2, y2));
        }
    }
}

