/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.net;

import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.net.ConnectionDispatcher;
import org.limewire.nio.channel.AbstractChannelInterestReader;
import org.limewire.nio.ssl.SSLUtils;
import org.limewire.nio.ssl.TLSNIOSocket;
import org.limewire.util.BufferUtils;

public class AsyncConnectionDispatcher
extends AbstractChannelInterestReader {
    private static final Log LOG = LogFactory.getLog(AsyncConnectionDispatcher.class);
    private final ConnectionDispatcher dispatcher;
    private final Socket socket;
    private final String allowedWord;
    private boolean finished = false;

    public AsyncConnectionDispatcher(ConnectionDispatcher dispatcher, Socket socket, String allowedWord) {
        super(dispatcher.getMaximumWordSize() + 1);
        if (socket == null) {
            throw new IllegalArgumentException();
        }
        this.dispatcher = dispatcher;
        this.socket = socket;
        this.allowedWord = allowedWord;
    }

    public void handleRead() throws IOException {
        if (this.finished) {
            this.source.interestRead(false);
            return;
        }
        int read = 0;
        while (this.buffer.hasRemaining() && (read = this.source.read(this.buffer)) > 0) {
        }
        for (int i = 0; i < this.buffer.position(); ++i) {
            if (this.buffer.get(i) != 32) continue;
            String word = new String(this.buffer.array(), 0, i);
            if (this.dispatcher.isValidProtocolWord(word)) {
                if (this.allowedWord != null && !this.allowedWord.equals(word)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Legal but wrong word: " + word);
                    }
                    throw new IOException("wrong word!");
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Dispatching word: " + word);
                }
                this.buffer.limit(this.buffer.position()).position(i + 1);
                this.source.interestRead(false);
                this.dispatcher.dispatch(word, this.socket, true);
            } else {
                this.startTLS();
            }
            this.finished = true;
            return;
        }
        if (!this.buffer.hasRemaining()) {
            this.startTLS();
            this.finished = true;
            return;
        }
        if (read == -1) {
            this.close();
            return;
        }
    }

    private void startTLS() throws IOException {
        if (!SSLUtils.isTLSEnabled(this.socket) && SSLUtils.isStartTLSCapable(this.socket)) {
            LOG.debug("Attempting to start TLS");
            this.buffer.flip();
            TLSNIOSocket tlsSocket = SSLUtils.startTLS(this.socket, this.buffer);
            tlsSocket.setReadObserver(new AsyncConnectionDispatcher(this.dispatcher, tlsSocket, this.allowedWord));
        } else {
            this.close();
        }
    }

    public int read(ByteBuffer dst) {
        return BufferUtils.transfer(this.buffer, dst, false);
    }

    public long read(ByteBuffer[] dst) {
        return BufferUtils.transfer(this.buffer, dst, 0, dst.length, false);
    }

    public long read(ByteBuffer[] dst, int offset, int length) {
        return BufferUtils.transfer(this.buffer, dst, offset, length, false);
    }
}

