/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.net;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import org.limewire.io.IOUtils;
import org.limewire.net.ConnectionDispatcher;

public class BlockingConnectionDispatcher
implements Runnable {
    private final ConnectionDispatcher dispatcher;
    private final Socket socket;
    private final String allowedWord;

    public BlockingConnectionDispatcher(ConnectionDispatcher dispatcher, Socket socket, String allowedWord) {
        if (dispatcher == null) {
            throw new IllegalArgumentException();
        }
        if (socket == null) {
            throw new IllegalArgumentException();
        }
        this.dispatcher = dispatcher;
        this.socket = socket;
        this.allowedWord = allowedWord;
    }

    protected void shutdown() {
    }

    public void run() {
        try {
            InputStream in = null;
            try {
                in = this.socket.getInputStream();
            }
            catch (IOException e) {
                this.shutdown();
                throw e;
            }
            catch (NullPointerException e) {
                throw new IOException(e.getMessage());
            }
            String word = IOUtils.readLargestWord(in, this.dispatcher.getMaximumWordSize());
            if (this.allowedWord != null && !this.allowedWord.equals(word)) {
                throw new IOException("wrong word!");
            }
            this.dispatcher.dispatch(word, this.socket, false);
        }
        catch (IOException iox) {
            this.shutdown();
            IOUtils.close(this.socket);
        }
    }
}

