/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.net;

import com.google.inject.Inject;
import java.net.Socket;
import java.net.SocketException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.ThreadExecutor;
import org.limewire.io.IOUtils;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;
import org.limewire.net.ConnectionAcceptor;
import org.limewire.net.ConnectionDispatcher;

public class ConnectionDispatcherImpl
implements ConnectionDispatcher {
    private static final Log LOG = LogFactory.getLog(ConnectionDispatcherImpl.class);
    private final Map<String, Delegator> protocols = Collections.synchronizedMap(new HashMap());
    private int longestWordSize = 0;
    private final NetworkInstanceUtils networkInstanceUtils;

    @Inject
    public ConnectionDispatcherImpl(NetworkInstanceUtils networkInstanceUtils) {
        this.networkInstanceUtils = networkInstanceUtils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaximumWordSize() {
        Map<String, Delegator> map = this.protocols;
        synchronized (map) {
            return this.longestWordSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionAcceptor(ConnectionAcceptor acceptor, boolean localOnly, String ... words) {
        Delegator d = new Delegator(acceptor, localOnly, acceptor.isBlocking());
        Map<String, Delegator> map = this.protocols;
        synchronized (map) {
            for (int i = 0; i < words.length; ++i) {
                if (words[i].length() > this.longestWordSize) {
                    this.longestWordSize = words[i].length();
                }
                this.protocols.put(words[i], d);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionAcceptor(String ... words) {
        Map<String, Delegator> map = this.protocols;
        synchronized (map) {
            this.protocols.keySet().removeAll(Arrays.asList(words));
            this.longestWordSize = 0;
            for (String word : this.protocols.keySet()) {
                if (word.length() <= this.longestWordSize) continue;
                this.longestWordSize = word.length();
            }
        }
    }

    public boolean isValidProtocolWord(String word) {
        return this.protocols.containsKey(word);
    }

    public void dispatch(String word, Socket client, boolean newThread) {
        try {
            client.setSoTimeout(0);
        }
        catch (SocketException se) {
            se.printStackTrace();
            LOG.warn("Unable to set soTimeout, closing client", se);
            IOUtils.close(client);
            return;
        }
        Delegator delegator = this.protocols.get(word);
        if (delegator == null) {
            System.out.println("no pro: " + word);
            if (LOG.isErrorEnabled()) {
                LOG.error("Unknown protocol: " + word);
            }
            IOUtils.close(client);
            return;
        }
        delegator.delegate(word, client, newThread);
    }

    private class Delegator {
        private final ConnectionAcceptor acceptor;
        private final boolean localOnly;
        private final boolean blocking;

        Delegator(ConnectionAcceptor acceptor, boolean localOnly, boolean blocking) {
            this.acceptor = acceptor;
            this.localOnly = localOnly;
            this.blocking = blocking;
        }

        public void delegate(final String word, final Socket sock, boolean newThread) {
            boolean localHost = NetworkUtils.isLocalHost(sock);
            boolean drop = false;
            if (this.localOnly && !localHost) {
                LOG.debug("Dropping because we want a local connection, and this isn't localhost");
                drop = true;
            }
            if (!this.localOnly && localHost && ConnectionDispatcherImpl.this.networkInstanceUtils.isPrivateAddress(sock.getLocalAddress())) {
                LOG.debug("Dropping because we want an external connection, and this is localhost");
                drop = true;
            }
            if (drop) {
                IOUtils.close(sock);
                return;
            }
            if (this.blocking && newThread) {
                Runnable r = new Runnable(){

                    public void run() {
                        Delegator.this.acceptor.acceptConnection(word, sock);
                    }
                };
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Spawning new thread to dispatch: " + word);
                }
                ThreadExecutor.startThread(r, "IncomingConnection");
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Handling dispatched word: " + word + " in same thread");
                }
                this.acceptor.acceptConnection(word, sock);
            }
        }
    }
}

