/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.net;

import com.google.inject.AbstractModule;
import org.limewire.net.LimitedSocketController;
import org.limewire.net.ProxyManager;
import org.limewire.net.ProxyManagerImpl;
import org.limewire.net.ProxySettings;
import org.limewire.net.SimpleSocketController;
import org.limewire.net.SocketBindingSettings;
import org.limewire.net.SocketController;
import org.limewire.net.SocketsManager;
import org.limewire.net.SocketsManagerImpl;
import org.limewire.net.WhoIsRequestFactory;
import org.limewire.net.WhoIsRequestFactoryImpl;
import org.limewire.util.OSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LimeWireNetModule
extends AbstractModule {
    private final Class<? extends ProxySettings> proxySettings;
    private final Class<? extends SocketBindingSettings> socketBindingSettings;

    public LimeWireNetModule() {
        this(null, null);
    }

    public LimeWireNetModule(Class<? extends ProxySettings> proxySettings, Class<? extends SocketBindingSettings> socketBindingSettings) {
        this.proxySettings = proxySettings;
        this.socketBindingSettings = socketBindingSettings;
    }

    @Override
    protected void configure() {
        this.bind(SocketsManager.class).to(SocketsManagerImpl.class);
        this.bind(ProxyManager.class).to(ProxyManagerImpl.class);
        this.bind(WhoIsRequestFactory.class).to(WhoIsRequestFactoryImpl.class);
        if (OSUtils.isSocketChallengedWindows()) {
            this.bind(SocketController.class).to(LimitedSocketController.class);
        } else {
            this.bind(SocketController.class).to(SimpleSocketController.class);
        }
        if (this.proxySettings != null) {
            this.bind(ProxySettings.class).to(this.proxySettings);
        }
        if (this.socketBindingSettings != null) {
            this.bind(SocketBindingSettings.class).to(this.socketBindingSettings);
        }
    }
}

