/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.net;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.IOUtils;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.net.ProxyManager;
import org.limewire.net.ProxySettings;
import org.limewire.nio.channel.NIOMultiplexor;
import org.limewire.nio.observer.ConnectObserver;
import org.limewire.nio.statemachine.BlockingStateMachine;
import org.limewire.nio.statemachine.IOState;
import org.limewire.nio.statemachine.IOStateMachine;
import org.limewire.nio.statemachine.IOStateObserver;
import org.limewire.nio.statemachine.PossibleIOState;
import org.limewire.nio.statemachine.ReadSkipState;
import org.limewire.nio.statemachine.ReadState;
import org.limewire.nio.statemachine.SimpleReadState;
import org.limewire.nio.statemachine.SimpleWriteState;
import org.limewire.util.BufferUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
class ProxyManagerImpl
implements ProxyManager {
    private static final Log LOG = LogFactory.getLog(ProxyManagerImpl.class);
    private final ProxySettings proxySettings;
    private final NetworkInstanceUtils networkInstanceUtils;

    @Inject
    public ProxyManagerImpl(ProxySettings proxySettings, NetworkInstanceUtils networkInstanceUtils) {
        this.proxySettings = proxySettings;
        this.networkInstanceUtils = networkInstanceUtils;
    }

    @Override
    public ProxySettings.ProxyType getProxyType(InetAddress address) {
        boolean valid;
        ProxySettings.ProxyType connectionType = this.proxySettings.getCurrentProxyType();
        assert (connectionType != null);
        boolean bl = valid = connectionType != ProxySettings.ProxyType.NONE && (!this.networkInstanceUtils.isPrivateAddress(address) || this.proxySettings.isProxyForPrivateEnabled());
        if (valid) {
            return connectionType;
        }
        return ProxySettings.ProxyType.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Socket establishProxy(ProxySettings.ProxyType type, Socket proxySocket, InetSocketAddress addr, int timeout) throws IOException {
        proxySocket.setSoTimeout(timeout);
        List<IOState> states = this.getProxyStates(type, addr);
        InputStream in = proxySocket.getInputStream();
        OutputStream out = proxySocket.getOutputStream();
        BlockingStateMachine bsm = new BlockingStateMachine(states, in, out);
        try {
            bsm.process();
        }
        finally {
            bsm.shutdown();
        }
        proxySocket.setSoTimeout(0);
        return proxySocket;
    }

    @Override
    public ProxyManager.ProxyConnector getConnectorFor(ProxySettings.ProxyType type, ConnectObserver observer, InetSocketAddress host, int timeout) {
        return new ProxyConnectorImpl(type, observer, host, timeout);
    }

    @Override
    public InetSocketAddress getProxyHost() throws UnknownHostException {
        return new InetSocketAddress(this.proxySettings.getProxyHost(), this.proxySettings.getProxyPort());
    }

    private List<IOState> getProxyStates(ProxySettings.ProxyType type, InetSocketAddress addr) throws IOException {
        switch (type) {
            case HTTP: {
                return this.getHttpStates(addr);
            }
            case SOCKS4: {
                return this.getSocksV4States(addr);
            }
            case SOCKS5: {
                return this.getSocksV5States(addr);
            }
        }
        throw new IOException("Unknown proxy type.");
    }

    private List<IOState> getSocksV4States(InetSocketAddress addr) {
        LinkedList<IOState> states = new LinkedList<IOState>();
        byte[] hostBytes = addr.getAddress().getAddress();
        int port = addr.getPort();
        byte[] portBytes = new byte[]{(byte)(port >> 8), (byte)port};
        boolean auth = this.proxySettings.isProxyAuthenticationRequired();
        String authName = this.proxySettings.getProxyUsername();
        byte[] authData = auth ? authName.getBytes() : new byte[]{};
        ByteBuffer outgoing = ByteBuffer.allocate(2 + portBytes.length + hostBytes.length + authData.length + 1);
        outgoing.put((byte)4);
        outgoing.put((byte)1);
        outgoing.put(portBytes);
        outgoing.put(hostBytes);
        outgoing.put(authData);
        outgoing.put((byte)0);
        outgoing.flip();
        states.add(new SimpleWriteState(outgoing));
        states.add(new SimpleReadState(8){

            public void validateBuffer(ByteBuffer buffer) throws IOException {
                byte version = buffer.get(0);
                if (version != 0 && version != 4) {
                    throw new IOException("Invalid version from socks proxy: " + version + " expected 0 or 4");
                }
                byte status = buffer.get(1);
                if (status != 90) {
                    throw new IOException("Request rejected with status: " + status);
                }
            }
        });
        return states;
    }

    private List<IOState> getSocksV5States(InetSocketAddress addr) {
        String password;
        byte[] byArray;
        LinkedList<IOState> states = new LinkedList<IOState>();
        if (this.proxySettings.isProxyAuthenticationRequired()) {
            byte[] byArray2 = new byte[3];
            byArray2[0] = 2;
            byArray2[1] = 0;
            byArray = byArray2;
            byArray2[2] = 2;
        } else {
            byte[] byArray3 = new byte[2];
            byArray3[0] = 1;
            byArray = byArray3;
            byArray3[1] = 0;
        }
        byte[] auths = byArray;
        ByteBuffer outgoing = ByteBuffer.allocate(1 + auths.length);
        outgoing.put((byte)5);
        outgoing.put(auths);
        outgoing.flip();
        states.add(new SimpleWriteState(outgoing));
        final AtomicBoolean authSwitch = new AtomicBoolean(false);
        states.add(new SimpleReadState(2){

            public void validateBuffer(ByteBuffer buffer) throws IOException {
                byte version = buffer.get(0);
                if (version != 5) {
                    throw new IOException("Invalid version from socks proxy: " + version + " expected 5");
                }
                byte auth_method = buffer.get(1);
                if (auth_method == 2) {
                    authSwitch.set(true);
                }
            }
        });
        String username = this.proxySettings.getProxyUsername();
        if (username == null) {
            username = "";
        }
        if ((password = this.proxySettings.getProxyPassword()) == null) {
            password = "";
        }
        outgoing = ByteBuffer.allocate(2 + username.length() + 1 + password.length());
        outgoing.put((byte)1);
        outgoing.put((byte)username.length());
        outgoing.put(username.getBytes());
        outgoing.put((byte)password.length());
        outgoing.put(password.getBytes());
        outgoing.flip();
        states.add(new PossibleIOState(authSwitch, new SimpleWriteState(outgoing)));
        states.add(new PossibleIOState(authSwitch, new SimpleReadState(2){

            public void validateBuffer(ByteBuffer buffer) throws IOException {
                byte version = buffer.get(0);
                if (version != 1) {
                    throw new IOException("Invalid version for authentication: " + version + " expected 1");
                }
                byte status = buffer.get(1);
                if (status != 0) {
                    throw new IOException("Authentication failed with status: " + status);
                }
            }
        }));
        byte[] hostBytes = addr.getAddress().getAddress();
        int port = addr.getPort();
        byte[] portBytes = new byte[]{(byte)(port >> 8), (byte)port};
        outgoing = ByteBuffer.allocate(4 + hostBytes.length + portBytes.length);
        outgoing.put((byte)5);
        outgoing.put((byte)1);
        outgoing.put((byte)0);
        outgoing.put((byte)1);
        outgoing.put(hostBytes);
        outgoing.put(portBytes);
        outgoing.flip();
        states.add(new SimpleWriteState(outgoing));
        final AtomicLong amountToSkip = new AtomicLong(0L);
        final AtomicBoolean domainLengthSwitch = new AtomicBoolean(false);
        states.add(new SimpleReadState(4){

            public void validateBuffer(ByteBuffer buffer) throws IOException {
                byte version = buffer.get(0);
                if (version != 5) {
                    throw new IOException("Invalid version from socks proxy: " + version + " expected 5");
                }
                byte status = buffer.get(1);
                if (status != 0) {
                    throw new IOException("Request rejected with status: " + status);
                }
                byte addrType = buffer.get(3);
                switch (addrType) {
                    case 1: {
                        amountToSkip.set(6L);
                        break;
                    }
                    case 3: {
                        domainLengthSwitch.set(true);
                        break;
                    }
                    case 4: {
                        amountToSkip.set(18L);
                    }
                }
            }
        });
        states.add(new PossibleIOState(domainLengthSwitch, new SimpleReadState(1){

            public void validateBuffer(ByteBuffer buffer) throws IOException {
                amountToSkip.set(buffer.get(0) + 2);
            }
        }));
        states.add(new ReadSkipState(amountToSkip));
        return states;
    }

    private List<IOState> getHttpStates(InetSocketAddress addr) {
        LinkedList<IOState> states = new LinkedList<IOState>();
        String connectString = "CONNECT " + addr.getAddress().getHostAddress() + ":" + addr.getPort() + " HTTP/1.0\r\n\r\n";
        ByteBuffer outgoing = ByteBuffer.wrap(connectString.getBytes());
        states.add(new SimpleWriteState(outgoing));
        states.add(new ReadState(){
            private StringBuilder sb = new StringBuilder();
            private boolean found200 = false;
            private ByteBuffer buffer;

            protected boolean processRead(ReadableByteChannel channel, ByteBuffer scratchBuffer) throws IOException {
                int read;
                if (this.buffer == null) {
                    this.buffer = scratchBuffer.slice();
                    this.buffer.limit(1);
                }
                while ((read = channel.read(this.buffer)) > 0) {
                    this.buffer.flip();
                    if (BufferUtils.readLine(this.buffer, this.sb)) {
                        if (!this.found200) {
                            if (this.sb.indexOf("200") == -1) {
                                throw new IOException("HTTP connection failed");
                            }
                            this.found200 = true;
                        }
                        if (this.sb.length() == 0) {
                            return false;
                        }
                        this.sb = new StringBuilder();
                    }
                    if (this.sb.length() > 2048) {
                        throw new IOException("header too big.");
                    }
                    this.buffer.position(0);
                    this.buffer.limit(1);
                }
                if (read == -1) {
                    throw new IOException("EOF");
                }
                return true;
            }

            public long getAmountProcessed() {
                return -1L;
            }
        });
        return states;
    }

    private class ProxyConnectorImpl
    implements ProxyManager.ProxyConnector,
    IOStateObserver {
        private final ProxySettings.ProxyType proxyType;
        private final ConnectObserver delegate;
        private final InetSocketAddress addr;
        private final int timeout;
        private volatile Socket socket;

        ProxyConnectorImpl(ProxySettings.ProxyType type, ConnectObserver observer, InetSocketAddress host, int tout) {
            this.proxyType = type;
            this.delegate = observer;
            this.addr = host;
            this.timeout = tout;
        }

        public void handleConnect(Socket s) throws IOException {
            this.socket = s;
            s.setSoTimeout(this.timeout);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Connected to proxy, beginning proxy handshake for addr: " + this.addr);
            }
            IOStateMachine machine = new IOStateMachine(this, ProxyManagerImpl.this.getProxyStates(this.proxyType, this.addr));
            ((NIOMultiplexor)((Object)this.socket)).setReadObserver(machine);
            ((NIOMultiplexor)((Object)this.socket)).setWriteObserver(machine);
        }

        public void shutdown() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Failed to connect with proxy to addr: " + this.addr);
            }
            this.delegate.shutdown();
        }

        public void handleIOException(IOException iox) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Failed to connect with proxy to addr: " + this.addr, iox);
            }
            this.delegate.shutdown();
        }

        public ConnectObserver getDelegateObserver() {
            return this.delegate;
        }

        public void handleStatesFinished() {
            try {
                this.socket.setSoTimeout(0);
            }
            catch (IOException ignored) {
                // empty catch block
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Finished proxy handshake, notifying connector for address: " + this.addr);
            }
            try {
                this.delegate.handleConnect(this.socket);
            }
            catch (IOException iox) {
                IOUtils.close(this.socket);
            }
        }
    }
}

