/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.net;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.limewire.concurrent.ThreadExecutor;
import org.limewire.io.IOUtils;
import org.limewire.io.NetworkUtils;
import org.limewire.net.AsyncConnectionDispatcher;
import org.limewire.net.BlockingConnectionDispatcher;
import org.limewire.net.ConnectionDispatcher;
import org.limewire.nio.SocketFactory;
import org.limewire.nio.channel.NIOMultiplexor;
import org.limewire.nio.observer.AcceptObserver;

public class SocketAcceptor {
    private final ConnectionDispatcher dispatcher;
    private ServerSocket listeningSocket = null;
    private volatile int listeningPort = -1;
    private volatile boolean localOnly;

    public SocketAcceptor(ConnectionDispatcher connectionDispatcher) {
        this.dispatcher = connectionDispatcher;
    }

    public boolean isLocalOnly() {
        return this.localOnly;
    }

    public void setLocalOnly(boolean localOnly) {
        this.localOnly = localOnly;
    }

    public synchronized void bind(int port) throws IOException {
        if (this.listeningSocket != null && this.listeningPort == port) {
            return;
        }
        ServerSocket newSocket = SocketFactory.newServerSocket(port, new SocketListener());
        if (this.listeningSocket != null) {
            IOUtils.close(this.listeningSocket);
        }
        this.listeningSocket = newSocket;
        this.listeningPort = port;
    }

    public synchronized void unbind() {
        if (this.listeningSocket == null) {
            return;
        }
        IOUtils.close(this.listeningSocket);
        this.listeningSocket = null;
        this.listeningPort = -1;
    }

    public int getPort() {
        return this.listeningPort;
    }

    public ConnectionDispatcher getDispatcher() {
        return this.dispatcher;
    }

    private class SocketListener
    implements AcceptObserver {
        private SocketListener() {
        }

        public void handleIOException(IOException ignored) {
        }

        public void shutdown() {
        }

        public void handleAccept(Socket client) {
            if (SocketAcceptor.this.isLocalOnly() && !NetworkUtils.isLocalHost(client)) {
                IOUtils.close(client);
                return;
            }
            if (client instanceof NIOMultiplexor) {
                ((NIOMultiplexor)((Object)client)).setReadObserver(new AsyncConnectionDispatcher(SocketAcceptor.this.dispatcher, client, null));
            } else {
                ThreadExecutor.startThread(new BlockingConnectionDispatcher(SocketAcceptor.this.dispatcher, client, null), "BlockingConnectionDispatchRunner");
            }
        }
    }
}

