/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.net;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.limewire.io.NetworkUtils;
import org.limewire.io.SimpleNetworkInstanceUtils;
import org.limewire.net.EmptyProxySettings;
import org.limewire.net.EmptySocketBindingSettings;
import org.limewire.net.ProxyManagerImpl;
import org.limewire.net.SimpleSocketController;
import org.limewire.net.SocketController;
import org.limewire.net.SocketsManager;
import org.limewire.nio.NBSocket;
import org.limewire.nio.NBSocketFactory;
import org.limewire.nio.observer.ConnectObserver;

@Singleton
public class SocketsManagerImpl
implements SocketsManager {
    private final SocketController socketController;

    public SocketsManagerImpl() {
        this(new SimpleSocketController(new ProxyManagerImpl(new EmptyProxySettings(), new SimpleNetworkInstanceUtils()), new EmptySocketBindingSettings()));
    }

    @Inject
    public SocketsManagerImpl(SocketController socketController) {
        this.socketController = socketController;
    }

    public Socket create(SocketsManager.ConnectType type) throws IOException {
        return type.getFactory().createSocket();
    }

    public Socket connect(NBSocket socket, InetSocketAddress localAddr, InetSocketAddress addr, int timeout, SocketsManager.ConnectType type) throws IOException {
        return this.connect(socket, localAddr, addr, timeout, null, type);
    }

    public Socket connect(InetSocketAddress addr, int timeout) throws IOException {
        return this.connect(addr, timeout, SocketsManager.ConnectType.PLAIN);
    }

    public Socket connect(InetSocketAddress addr, int timeout, SocketsManager.ConnectType type) throws IOException {
        return this.connect(addr, timeout, null, type);
    }

    public Socket connect(InetSocketAddress addr, int timeout, ConnectObserver observer) throws IOException {
        return this.connect(addr, timeout, observer, SocketsManager.ConnectType.PLAIN);
    }

    public Socket connect(InetSocketAddress addr, int timeout, ConnectObserver observer, SocketsManager.ConnectType type) throws IOException {
        return this.connect(null, null, addr, timeout, observer, type);
    }

    public Socket connect(final NBSocket socket, InetSocketAddress localAddr, InetSocketAddress addr, int timeout, ConnectObserver observer, SocketsManager.ConnectType type) throws IOException {
        if (!NetworkUtils.isValidPort(addr.getPort())) {
            throw new IllegalArgumentException("port out of range: " + addr.getPort());
        }
        if (addr.isUnresolved()) {
            throw new IOException("address must be resolved!");
        }
        if (socket == null) {
            return this.socketController.connect(type.getFactory(), addr, null, timeout, observer);
        }
        NBSocketFactory factory = new NBSocketFactory(){

            public NBSocket createSocket() throws IOException {
                return socket;
            }

            public NBSocket createSocket(String host, int port) throws IOException, UnknownHostException {
                throw new UnsupportedOperationException();
            }

            public NBSocket createSocket(InetAddress host, int port) throws IOException {
                throw new UnsupportedOperationException();
            }

            public NBSocket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
                throw new UnsupportedOperationException();
            }

            public NBSocket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
                throw new UnsupportedOperationException();
            }
        };
        return this.socketController.connect(factory, addr, localAddr, timeout, observer);
    }

    public boolean removeConnectObserver(ConnectObserver observer) {
        return this.socketController.removeConnectObserver(observer);
    }

    public int getNumAllowedSockets() {
        return this.socketController.getNumAllowedSockets();
    }

    public int getNumWaitingSockets() {
        return this.socketController.getNumWaitingSockets();
    }
}

