/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.limewire.io.IOUtils;
import org.limewire.io.IP;
import org.limewire.io.NetworkUtils;
import org.limewire.net.SocketsManager;
import org.limewire.net.WhoIsRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WhoIsRequestImpl
implements WhoIsRequest {
    protected Map<String, String> servers;
    protected String name;
    protected Map<String, String> values;
    protected String whoisServer;
    protected Set<String> referrals;
    protected SocketsManager socketsManager;

    public WhoIsRequestImpl(String name, SocketsManager socketsManager, Map<String, String> defaultServers) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("Zero-length name is not allowed.");
        }
        int ndx = name.lastIndexOf(".");
        if (ndx == -1 || ndx == name.length() - 1) {
            throw new IllegalArgumentException("Invalid request name.");
        }
        this.name = name;
        this.values = new HashMap<String, String>();
        this.socketsManager = socketsManager;
        this.referrals = new HashSet<String>();
        this.servers = defaultServers;
    }

    @Override
    public void doRequest() throws IOException {
        String referral;
        if (this.whoisServer == null) {
            this.whoisServer = this.getWhoIsServer();
        }
        if (this.whoisServer == null) {
            throw new IllegalArgumentException("Unsupported request name, '" + this.name + "'");
        }
        this.referrals.add(this.whoisServer);
        StringTokenizer st = new StringTokenizer(this.doRequestGetWhoIsResponse(), "\r\n");
        String name = null;
        StringBuilder value = new StringBuilder(100);
        boolean skipTillRegistrant = false;
        while (st.hasMoreTokens()) {
            int index = 0;
            String line = st.nextToken().trim();
            if (skipTillRegistrant) {
                if (-1 == line.indexOf("Registrant:")) {
                    continue;
                }
            } else {
                if (-1 != line.indexOf(">>>") || -1 != line.indexOf("NOTICE:") || -1 != line.indexOf("TERMS OF USE:")) {
                    skipTillRegistrant = true;
                    continue;
                }
                if (line.startsWith("#")) continue;
            }
            if (name != null) {
                index = line.indexOf(":");
                if (-1 != index) {
                    this.setValue(name.toUpperCase(Locale.ENGLISH), value.toString());
                    name = line.substring(0, index);
                    value = new StringBuilder(100);
                    if ((line = line.substring(index + 1).trim()).length() <= 0) continue;
                    if (line.startsWith("//")) {
                        name = null;
                        continue;
                    }
                    this.setValue(name.toUpperCase(Locale.ENGLISH), line);
                    name = null;
                    continue;
                }
                if (value.length() != 0) {
                    value.append(" ");
                    value.append(line);
                    continue;
                }
                value.append(line);
                continue;
            }
            index = line.indexOf(":");
            if (-1 == index) continue;
            name = line.substring(0, index);
            if ((line = line.substring(index + 1).trim()).length() <= 0) continue;
            if (line.startsWith("//")) {
                name = null;
                continue;
            }
            this.setValue(name.toUpperCase(Locale.ENGLISH), line);
            name = null;
        }
        if (this.name != null) {
            this.setValue(this.name.toUpperCase(Locale.ENGLISH), value.toString());
        }
        if ((referral = this.values.get("WHOIS SERVER")) != null && referral.length() != 0 && !this.referrals.contains(referral)) {
            this.whoisServer = referral;
            this.doRequest();
        }
    }

    public String getValue(String name) {
        return this.values.get(name);
    }

    protected void setValue(String name, String value) {
        this.values.put(name, value);
    }

    @Override
    public IP getNetRange() {
        String range = this.getValue("CIDR");
        if (range != null) {
            return new IP(range);
        }
        return null;
    }

    protected String doRequestGetWhoIsResponse() throws IOException {
        StringBuilder sb = new StringBuilder(1000);
        Socket socket = null;
        try {
            socket = this.socketsManager.connect(new InetSocketAddress(this.whoisServer, 43), 0);
            InputStream is = socket.getInputStream();
            OutputStream os = socket.getOutputStream();
            byte[] bytes = new byte[1000];
            int read = 0;
            os.write((this.name + "\r\n").getBytes());
            try {
                while (0 < (read = is.read(bytes, 0, 1000))) {
                    if (read <= 0) continue;
                    sb.append(new String(bytes, 0, read, "US-ASCII"));
                }
            }
            catch (IOException e2) {
                // empty catch block
            }
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                IOUtils.close(socket);
                throw throwable;
            }
        }
        IOUtils.close(socket);
        return sb.toString();
    }

    public String getWhoIsServer() {
        String server = null;
        server = NetworkUtils.isDottedIPV4(this.name) ? this.servers.get("0") : this.servers.get(this.name.substring(this.name.lastIndexOf(".") + 1).toLowerCase(Locale.ENGLISH));
        return server;
    }
}

