/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import org.limewire.concurrent.ThreadExecutor;
import org.limewire.nio.NBSocket;
import org.limewire.nio.observer.ConnectObserver;
import org.limewire.nio.observer.Shutdownable;

public class BlockingSocketAdapter
extends NBSocket {
    private volatile Shutdownable shutdownObserver;

    public BlockingSocketAdapter() {
    }

    public BlockingSocketAdapter(InetAddress addr, int port) throws IOException {
        super(addr, port);
    }

    public BlockingSocketAdapter(InetAddress addr, int port, InetAddress localAddr, int localPort) throws IOException {
        super(addr, port, localAddr, localPort);
    }

    public BlockingSocketAdapter(String addr, int port) throws UnknownHostException, IOException {
        super(addr, port);
    }

    public BlockingSocketAdapter(String addr, int port, InetAddress localAddr, int localPort) throws IOException {
        super(addr, port, localAddr, localPort);
    }

    public boolean connect(final SocketAddress addr, final int timeout, final ConnectObserver observer) {
        ThreadExecutor.startThread(new Runnable(){

            public void run() {
                try {
                    BlockingSocketAdapter.this.connect(addr, timeout);
                    observer.handleConnect(BlockingSocketAdapter.this);
                }
                catch (IOException x) {
                    observer.shutdown();
                }
            }
        }, "BlockingSocketEmulator");
        return false;
    }

    public void setShutdownObserver(Shutdownable observer) {
        this.shutdownObserver = observer;
    }

    public void close() throws IOException {
        this.shutdownObserver.shutdown();
        super.close();
    }
}

