/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import org.limewire.nio.InterruptedIOException;
import org.limewire.nio.NIOInputStream;
import org.limewire.nio.channel.InterestReadableByteChannel;
import org.limewire.nio.observer.Shutdownable;
import org.limewire.nio.timeout.ReadTimeout;

class BufferInputStream
extends InputStream
implements Shutdownable {
    private final Object LOCK = new Object();
    private final Shutdownable shutdownHandler;
    private final ReadTimeout readTimeoutHandler;
    private final ByteBuffer buffer;
    private final NIOInputStream nioStream;
    private InterestReadableByteChannel channel;
    private boolean shutdown = false;
    private boolean finished = false;

    BufferInputStream(ByteBuffer buffer, ReadTimeout timeout, Shutdownable shutdown, InterestReadableByteChannel channel, NIOInputStream stream) {
        this.readTimeoutHandler = timeout;
        this.shutdownHandler = shutdown;
        this.buffer = buffer;
        this.channel = channel;
        this.nioStream = stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setReadChannel(InterestReadableByteChannel newChannel) {
        Object object = this.LOCK;
        synchronized (object) {
            this.channel = newChannel;
        }
    }

    Object getBufferLock() {
        return this.LOCK;
    }

    void finished() {
        this.finished = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            this.waitImpl();
            if (this.finished && this.buffer.position() == 0) {
                return -1;
            }
            this.buffer.flip();
            byte read = this.buffer.get();
            this.buffer.compact();
            this.channel.interestRead(true);
            return read & 0xFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] buf, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.waitImpl();
            if (this.finished && this.buffer.position() == 0) {
                return -1;
            }
            this.buffer.flip();
            int available = Math.min(this.buffer.remaining(), len);
            this.buffer.get(buf, off, available);
            if (this.buffer.hasRemaining()) {
                this.buffer.compact();
            } else {
                this.buffer.clear();
            }
            this.channel.interestRead(true);
            return available;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            return this.buffer.position();
        }
    }

    private void waitImpl() throws IOException {
        long timeout = this.readTimeoutHandler.getReadTimeout();
        if (timeout == -1L) {
            throw new SocketException("unable to get read timeout");
        }
        boolean looped = false;
        while (this.buffer.position() == 0 && !this.finished) {
            if (this.shutdown) {
                throw new IOException("socket closed");
            }
            if (looped && timeout != 0L) {
                throw new SocketTimeoutException("read timed out (" + timeout + ")");
            }
            this.nioStream.readHappening();
            try {
                this.LOCK.wait(timeout);
            }
            catch (InterruptedException ix) {
                throw new InterruptedIOException(ix);
            }
            looped = true;
        }
        if (this.shutdown) {
            throw new IOException("socket closed");
        }
    }

    public void close() throws IOException {
        this.shutdownHandler.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.LOCK;
        synchronized (object) {
            this.shutdown = true;
            this.LOCK.notify();
        }
    }
}

