/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.limewire.nio.InterruptedIOException;
import org.limewire.nio.channel.InterestWritableByteChannel;
import org.limewire.nio.observer.Shutdownable;
import org.limewire.nio.observer.WriteObserver;

class BufferOutputStream
extends OutputStream
implements Shutdownable {
    private final Object LOCK = new Object();
    private final Shutdownable handler;
    private final WriteObserver writeObserver;
    private final ByteBuffer buffer;
    private final InterestWritableByteChannel channel;
    private boolean shutdown = false;

    BufferOutputStream(ByteBuffer buffer, Shutdownable handler, WriteObserver observer, InterestWritableByteChannel channel) {
        this.handler = handler;
        this.buffer = buffer;
        this.channel = channel;
        this.writeObserver = observer;
    }

    Object getBufferLock() {
        return this.LOCK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int x) throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            this.waitImpl();
            this.buffer.put((byte)(x & 0xFF));
            this.channel.interestWrite(this.writeObserver, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] buf, int off, int len) throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            while (len > 0) {
                this.waitImpl();
                int available = Math.min(this.buffer.remaining(), len);
                this.buffer.put(buf, off, available);
                off += available;
                len -= available;
                this.channel.interestWrite(this.writeObserver, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            while (this.buffer.position() > 0) {
                if (this.shutdown) {
                    throw new IOException("socket closed");
                }
                try {
                    this.LOCK.wait();
                }
                catch (InterruptedException ix) {
                    throw new InterruptedIOException(ix);
                }
            }
        }
    }

    private void waitImpl() throws IOException {
        while (!this.buffer.hasRemaining()) {
            if (this.shutdown) {
                throw new IOException("socket closed");
            }
            try {
                this.LOCK.wait();
            }
            catch (InterruptedException ix) {
                throw new InterruptedIOException(ix);
            }
        }
        if (this.shutdown) {
            throw new IOException("socket closed");
        }
    }

    public void close() {
        this.handler.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.LOCK;
        synchronized (object) {
            this.shutdown = true;
            this.LOCK.notify();
        }
    }
}

