/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio;

import com.google.inject.Singleton;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.ThreadExecutor;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectionPoint;
import org.limewire.nio.ByteBufferCache;
import org.limewire.nio.NBThrottle;
import org.limewire.nio.ScheduledFutureTask;
import org.limewire.nio.observer.AcceptChannelObserver;
import org.limewire.nio.observer.ConnectObserver;
import org.limewire.nio.observer.IOErrorObserver;
import org.limewire.nio.observer.ReadObserver;
import org.limewire.nio.observer.ReadWriteObserver;
import org.limewire.nio.observer.Shutdownable;
import org.limewire.nio.observer.TransportListener;
import org.limewire.nio.observer.WriteObserver;
import org.limewire.nio.timeout.ReadTimeout;
import org.limewire.nio.timeout.TimeoutController;
import org.limewire.nio.timeout.Timeoutable;
import org.limewire.service.ErrorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class NIODispatcher
implements Runnable {
    private static final Log LOG = LogFactory.getLog(NIODispatcher.class);
    private static final NIODispatcher INSTANCE = new NIODispatcher();
    private static final long SPIN_AMOUNT = 5000L;
    private static final int MAX_IGNORES = 5;
    private static final long CACHE_CLEAR_INTERVAL = 30000L;
    private final Thread dispatchThread;
    private final Object Q_LOCK = new Object();
    @InspectionPoint(value="nio selector stats")
    private final SelectStats stats = new SelectStats();
    private final TransportListener TRANSPORT_LISTENER = new MyTransportListener();
    private final ScheduledExecutorService EXECUTOR;
    private final Map<Class<? extends SelectableChannel>, Selector> OTHER_SELECTORS = new HashMap<Class<? extends SelectableChannel>, Selector>();
    private final List<Selector> POLLERS = new ArrayList<Selector>();
    private Collection<Runnable> LATER = new LinkedList<Runnable>();
    private final BlockingQueue<ScheduledFutureTask> DELAYED = new DelayQueue<ScheduledFutureTask>();
    private final List<NBThrottle> THROTTLE = new ArrayList<NBThrottle>();
    private final TimeoutController TIMEOUTER = new TimeoutController();
    private final ByteBufferCache BUFFER_CACHE = new ByteBufferCache();
    private Selector primarySelector = null;
    private long iteration = 0L;
    private volatile boolean wokeup = false;
    private long lastCacheClearTime;

    public static final NIODispatcher instance() {
        return INSTANCE;
    }

    private NIODispatcher() {
        boolean failed = false;
        try {
            this.primarySelector = Selector.open();
        }
        catch (IOException iox) {
            failed = true;
        }
        if (!failed) {
            this.dispatchThread = ThreadExecutor.newManagedThread(this, "NIODispatcher");
            this.dispatchThread.start();
        } else {
            this.dispatchThread = null;
        }
        this.EXECUTOR = new NIOExecutorService(this.dispatchThread);
    }

    public boolean isRunning() {
        return this.dispatchThread != null;
    }

    public boolean isDispatchThread() {
        return Thread.currentThread() == this.dispatchThread;
    }

    public ByteBufferCache getBufferCache() {
        return this.BUFFER_CACHE;
    }

    public int getNumPendingTimeouts() {
        return this.TIMEOUTER.getNumPendingTimeouts();
    }

    public void addThrottle(final NBThrottle t) {
        if (Thread.currentThread() == this.dispatchThread) {
            this.THROTTLE.add(t);
        } else {
            this.executeLaterAlways(new Runnable(){

                public void run() {
                    NIODispatcher.this.THROTTLE.add(t);
                }
            });
        }
    }

    public void register(SelectableChannel channel, IOErrorObserver attachment) {
        this.register(channel, attachment, 0, 0);
    }

    public void registerAccept(SelectableChannel channel, AcceptChannelObserver attachment) {
        this.register(channel, attachment, 16, 0);
    }

    public void registerConnect(SelectableChannel channel, ConnectObserver attachment, int timeout) {
        this.register(channel, attachment, 8, timeout);
    }

    public void registerRead(SelectableChannel channel, ReadObserver attachment) {
        this.register(channel, attachment, 1, 0);
    }

    public void registerWrite(SelectableChannel channel, WriteObserver attachment) {
        this.register(channel, attachment, 4, 0);
    }

    public void registerReadWrite(SelectableChannel channel, ReadWriteObserver attachment) {
        this.register(channel, attachment, 5, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(SelectableChannel channel, IOErrorObserver handler, int op, int timeout) {
        if (Thread.currentThread() == this.dispatchThread) {
            this.registerImpl(this.getSelectorFor(channel), channel, op, handler, timeout);
        } else {
            Object object = this.Q_LOCK;
            synchronized (object) {
                this.LATER.add(new RegisterOp(channel, handler, op, timeout));
            }
            this.wakeup();
        }
    }

    public void interestWrite(SelectableChannel channel, boolean on) {
        this.interest(channel, 4, on);
    }

    public void interestRead(SelectableChannel channel, boolean on) {
        this.interest(channel, 1, on);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interest(SelectableChannel channel, int op, boolean on) {
        block9: {
            try {
                int oldOps;
                Selector sel = this.getSelectorFor(channel);
                SelectionKey sk = channel.keyFor(sel);
                if (sk == null || !sk.isValid()) break block9;
                Object object = sk.attachment();
                synchronized (object) {
                    if ((op & 1) == 1) {
                        ((Attachment)sk.attachment()).changeReadStatus(on);
                    }
                    oldOps = sk.interestOps();
                    if (on) {
                        sk.interestOps(oldOps | op);
                    } else {
                        sk.interestOps(oldOps & ~op);
                    }
                }
                if (on && (oldOps & op) != op) {
                    this.wakeup();
                }
            }
            catch (CancelledKeyException ignored) {
                // empty catch block
            }
        }
    }

    private Selector getSelectorFor(SelectableChannel channel) {
        Selector sel = this.OTHER_SELECTORS.get(channel.getClass());
        if (sel == null) {
            return this.primarySelector;
        }
        return sel;
    }

    public void shutdown(Shutdownable handler) {
        handler.shutdown();
    }

    public void registerSelector(final Selector newSelector, final Class<? extends SelectableChannel> channelClass) {
        if (Thread.currentThread() == this.dispatchThread) {
            this.POLLERS.add(newSelector);
            this.OTHER_SELECTORS.put(channelClass, newSelector);
        } else {
            this.executeLaterAlways(new Runnable(){

                public void run() {
                    NIODispatcher.this.POLLERS.add(newSelector);
                    NIODispatcher.this.OTHER_SELECTORS.put(channelClass, newSelector);
                }
            });
        }
    }

    public void removeSelector(final Selector selector) {
        if (Thread.currentThread() == this.dispatchThread) {
            this.POLLERS.remove(selector);
            this.OTHER_SELECTORS.remove(selector);
        } else {
            this.executeLaterAlways(new Runnable(){

                public void run() {
                    NIODispatcher.this.POLLERS.remove(selector);
                    NIODispatcher.this.OTHER_SELECTORS.remove(selector);
                }
            });
        }
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.EXECUTOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeLaterAlways(Runnable runner) {
        Object object = this.Q_LOCK;
        synchronized (object) {
            this.LATER.add(runner);
        }
        this.wakeup();
    }

    public IOErrorObserver attachment(Object proxyAttachment) {
        return ((Attachment)proxyAttachment).attachment;
    }

    private void cancel(SelectionKey sk, Shutdownable handler) {
        sk.cancel();
        if (handler != null) {
            handler.shutdown();
        }
    }

    private void processAccept(long now, SelectionKey sk, AcceptChannelObserver handler, Attachment proxy) throws IOException {
        ServerSocketChannel ssc;
        SocketChannel channel;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Handling accept: " + handler);
        }
        if ((channel = (ssc = (ServerSocketChannel)sk.channel()).accept()) == null) {
            return;
        }
        if (channel.isOpen()) {
            channel.configureBlocking(false);
            handler.handleAcceptChannel(channel);
        } else {
            try {
                channel.close();
            }
            catch (IOException err) {
                LOG.error("SocketChannel.close()", err);
            }
        }
    }

    private void processConnect(long now, SelectionKey sk, ConnectObserver handler, Attachment proxy) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Handling connect: " + handler);
        }
        SocketChannel channel = (SocketChannel)sk.channel();
        proxy.clearTimeout();
        boolean finished = channel.finishConnect();
        if (finished) {
            sk.interestOps(0);
            handler.handleConnect(channel.socket());
        } else {
            this.cancel(sk, handler);
        }
    }

    private void processRead(long now, ReadObserver handler, Attachment proxy) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Handling read: " + handler);
        }
        proxy.updateReadTimeout(now);
        handler.handleRead();
    }

    private void processWrite(long now, WriteObserver handler, Attachment proxy) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Handling write: " + handler);
        }
        handler.handleWrite();
    }

    private void registerImpl(Selector selector, SelectableChannel channel, int op, IOErrorObserver attachment, int timeout) {
        try {
            SelectionKey existing = channel.keyFor(selector);
            if (existing != null) {
                Attachment old = (Attachment)existing.attachment();
                old.discard();
            }
            Attachment guard = new Attachment(attachment);
            SelectionKey key = channel.register(selector, op, guard);
            guard.setKey(key);
            if (timeout != 0) {
                guard.addTimeout(System.currentTimeMillis(), timeout);
            } else if ((op & 1) != 0) {
                guard.changeReadStatus(true);
            }
        }
        catch (IOException iox) {
            attachment.handleIOException(iox);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runPendingTasks() {
        Collection<Runnable> localLater;
        long now = System.currentTimeMillis();
        Object object = this.Q_LOCK;
        synchronized (object) {
            localLater = this.LATER;
            this.LATER = new LinkedList<Runnable>();
        }
        this.DELAYED.drainTo(localLater);
        if (now > this.lastCacheClearTime + 30000L) {
            this.BUFFER_CACHE.clearCache();
            this.lastCacheClearTime = now;
        }
        if (!localLater.isEmpty()) {
            for (Runnable item : localLater) {
                try {
                    item.run();
                }
                catch (Throwable t) {
                    LOG.error(t);
                    ErrorService.error(t);
                }
            }
        }
        now = System.currentTimeMillis();
        for (NBThrottle t : this.THROTTLE) {
            t.tick(now);
        }
    }

    private Collection<SelectionKey> pollOtherSelectors() {
        Set<SelectionKey> ret = null;
        boolean growable = false;
        for (int i = 0; i < this.POLLERS.size(); ++i) {
            Set<SelectionKey> selected;
            Selector sel = this.POLLERS.get(i);
            int n = 0;
            try {
                n = sel.selectNow();
            }
            catch (IOException iox) {
                LOG.error("Error performing secondary select", iox);
            }
            if (n == 0 || (selected = sel.selectedKeys()).isEmpty()) continue;
            if (ret == null) {
                ret = selected;
                continue;
            }
            if (!growable) {
                growable = true;
                ret = new HashSet<SelectionKey>(ret);
                ret.addAll(selected);
                continue;
            }
            ret.addAll(selected);
        }
        if (ret == null) {
            return Collections.emptySet();
        }
        return ret;
    }

    private void readyThrottles(Collection<SelectionKey> keys) {
        for (int i = 0; i < this.THROTTLE.size(); ++i) {
            this.THROTTLE.get(i).selectableKeys(keys);
        }
    }

    void wakeup() {
        if (!this.wokeup && Thread.currentThread() != this.dispatchThread) {
            this.wokeup = true;
            this.primarySelector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process() throws ProcessingException, SpinningException {
        boolean checkTime = false;
        long startSelect = -1L;
        int zeroes = 0;
        int ignores = 0;
        while (true) {
            Set<SelectionKey> allKeys;
            this.runPendingTasks();
            Collection<SelectionKey> polled = this.pollOtherSelectors();
            boolean immediate = !polled.isEmpty();
            try {
                if (!immediate && checkTime) {
                    startSelect = System.currentTimeMillis();
                }
                if (!immediate) {
                    long delay = this.nextSelectTimeout();
                    if (delay == 0L) {
                        immediate = true;
                    } else {
                        long nanoNow = System.nanoTime();
                        try {
                            if (Thread.interrupted()) {
                                LOG.warn("interrupted?");
                            }
                            this.primarySelector.select(Math.min(delay, Integer.MAX_VALUE));
                        }
                        finally {
                            this.stats.updateSelectTime(System.nanoTime() - nanoNow);
                        }
                    }
                }
                if (immediate) {
                    this.stats.countSelectNow();
                    this.primarySelector.selectNow();
                }
            }
            catch (NullPointerException err) {
                LOG.warn("npe", err);
                continue;
            }
            catch (CancelledKeyException err) {
                LOG.warn("cancelled", err);
                continue;
            }
            catch (IOException iox) {
                throw new ProcessingException(iox);
            }
            Set<SelectionKey> keys = this.primarySelector.selectedKeys();
            if (!immediate && !this.wokeup) {
                if (keys.isEmpty()) {
                    long now = System.currentTimeMillis();
                    if (startSelect == -1L) {
                        LOG.trace("No keys selected, starting spin check.");
                        checkTime = true;
                    } else if (startSelect + 30L >= now) {
                        if (LOG.isWarnEnabled()) {
                            LOG.warn("Spinning detected, current spins: " + zeroes + " startSelect " + startSelect + " now " + now + " keys " + this.primarySelector.keys());
                        }
                        if ((long)zeroes++ > 5000L) {
                            throw new SpinningException();
                        }
                    } else {
                        checkTime = false;
                        startSelect = -1L;
                        zeroes = 0;
                        ignores = 0;
                    }
                    this.TIMEOUTER.processTimeouts(now);
                    continue;
                }
                if (checkTime && ++ignores > 5) {
                    checkTime = false;
                    zeroes = 0;
                    startSelect = -1L;
                    ignores = 0;
                }
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Selected keys: (" + keys.size() + "), polled: (" + polled.size() + "). wokeup " + this.wokeup + " immediate " + immediate);
            }
            if (!polled.isEmpty()) {
                allKeys = new HashSet<SelectionKey>(keys.size() + polled.size());
                allKeys.addAll(keys);
                allKeys.addAll(polled);
            } else {
                allKeys = keys;
            }
            this.readyThrottles(allKeys);
            long now = System.currentTimeMillis();
            for (SelectionKey sk : allKeys) {
                this.process(now, sk, sk.attachment(), 65535);
            }
            keys.clear();
            ++this.iteration;
            this.TIMEOUTER.processTimeouts(now);
            this.wokeup = false;
        }
    }

    private long nextSelectTimeout() {
        long next = Long.MAX_VALUE;
        for (NBThrottle t : this.THROTTLE) {
            next = Math.min(next, t.nextTickTime());
        }
        long now = System.currentTimeMillis();
        if ((next -= now) <= 0L) {
            return 0L;
        }
        long timeout = this.TIMEOUTER.getNextExpireTime();
        if (timeout > -1L) {
            next = Math.min(next, timeout - now);
        }
        if (next <= 0L) {
            return 0L;
        }
        Delayed nextScheduled = (Delayed)this.DELAYED.peek();
        if (nextScheduled != null) {
            next = Math.min(next, nextScheduled.getDelay(TimeUnit.MILLISECONDS));
        }
        return Math.max(0L, next);
    }

    boolean isReadReadyThisIteration(SelectableChannel channel) {
        Attachment proxy;
        SelectionKey sk = channel.keyFor(this.getSelectorFor(channel));
        Object proxyAttachment = sk.attachment();
        if (proxyAttachment instanceof Attachment && (proxy = (Attachment)sk.attachment()).lastMod == this.iteration + 1L && sk.isValid()) {
            try {
                return (sk.readyOps() & ~proxy.handled & 1) != 0;
            }
            catch (CancelledKeyException ignored) {
                // empty catch block
            }
        }
        return false;
    }

    void process(long now, SelectionKey sk, Object proxyAttachment, int allowedOps) {
        Attachment proxy = (Attachment)proxyAttachment;
        IOErrorObserver attachment = proxy.attachment;
        if (proxy.lastMod <= this.iteration) {
            proxy.handled = 0;
        }
        proxy.lastMod = this.iteration + 1L;
        if (sk.isValid()) {
            try {
                try {
                    int notHandled = ~proxy.handled;
                    int readyOps = sk.readyOps();
                    if ((allowedOps & readyOps & notHandled & 0x10) != 0) {
                        proxy.handled |= 16;
                        this.processAccept(now, sk, (AcceptChannelObserver)attachment, proxy);
                    } else if ((allowedOps & readyOps & notHandled & 8) != 0) {
                        proxy.handled |= 8;
                        this.processConnect(now, sk, (ConnectObserver)attachment, proxy);
                    } else {
                        if ((allowedOps & readyOps & notHandled & 1) != 0) {
                            proxy.handled |= 1;
                            this.processRead(now, (ReadObserver)attachment, proxy);
                        }
                        if ((allowedOps & readyOps & notHandled & 4) != 0) {
                            proxy.handled |= 4;
                            this.processWrite(now, (WriteObserver)attachment, proxy);
                        }
                    }
                }
                catch (CancelledKeyException err) {
                    LOG.warn("Ignoring cancelled key", err);
                }
                catch (IOException iox) {
                    LOG.warn("IOX processing", iox);
                    try {
                        sk.cancel();
                    }
                    catch (Throwable ignored) {
                        // empty catch block
                    }
                    attachment.handleIOException(iox);
                }
            }
            catch (Throwable t) {
                ErrorService.error(t, "Unhandled exception while dispatching");
                this.safeCancel(sk, attachment);
            }
        } else {
            if (LOG.isErrorEnabled()) {
                LOG.error("SelectionKey cancelled for: " + attachment);
            }
            this.safeCancel(sk, attachment);
        }
    }

    private void safeCancel(SelectionKey sk, Shutdownable attachment) {
        try {
            this.cancel(sk, attachment);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void swapSelector() {
        Selector oldSelector = this.primarySelector;
        Set<Object> oldKeys = Collections.emptySet();
        try {
            if (oldSelector != null) {
                oldKeys = oldSelector.keys();
            }
        }
        catch (ClosedSelectorException ignored) {
            LOG.warn("error getting keys", ignored);
        }
        try {
            this.primarySelector = Selector.open();
        }
        catch (IOException iox) {
            LOG.error("Can't make a new selector!!!", iox);
            throw new RuntimeException(iox);
        }
        for (SelectionKey selectionKey : oldKeys) {
            try {
                SelectableChannel channel = selectionKey.channel();
                Attachment attachment = (Attachment)selectionKey.attachment();
                int ops = selectionKey.interestOps();
                try {
                    SelectionKey newKey = channel.register(this.primarySelector, ops, attachment);
                    attachment.setKey(newKey);
                }
                catch (IOException iox) {
                    attachment.attachment.handleIOException(iox);
                }
            }
            catch (CancelledKeyException ignored) {
                LOG.warn("key cancelled while swapping", ignored);
            }
        }
        try {
            if (oldSelector != null) {
                oldSelector.close();
            }
        }
        catch (IOException ignored) {
            LOG.warn("error closing old selector", ignored);
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    if (this.primarySelector == null) {
                        this.primarySelector = Selector.open();
                    }
                    this.process();
                }
            }
            catch (SpinningException spin) {
                LOG.warn("selector is spinning!", spin);
                this.swapSelector();
                continue;
            }
            catch (ProcessingException uhoh) {
                LOG.warn("unknown exception while selecting", uhoh);
                this.swapSelector();
                continue;
            }
            catch (IOException iox) {
                LOG.error("Unable to create a new Selector!!!", iox);
                throw new RuntimeException(iox);
            }
            catch (Throwable err) {
                LOG.error("Error in Selector!", err);
                ErrorService.error(err);
                this.swapSelector();
                continue;
            }
            break;
        }
    }

    public TransportListener getTransportListener() {
        return this.TRANSPORT_LISTENER;
    }

    public long[] getSelectStats() {
        return this.stats.getStats();
    }

    public static class SelectStats
    implements Inspectable {
        private long numSelects;
        private long numImmediateSelects;
        private long avgSelectTime;

        public synchronized long[] getStats() {
            return new long[]{this.numSelects, this.numImmediateSelects, this.avgSelectTime};
        }

        synchronized void updateSelectTime(long thisSelect) {
            long avg = this.avgSelectTime;
            long num = this.numSelects;
            avg = Math.max(0L, avg * Math.max(1L, num));
            ++num;
            num = Math.max(1L, num);
            avg = Math.max(0L, avg + thisSelect) / num;
            this.numSelects = num;
            this.avgSelectTime = avg;
        }

        synchronized void countSelectNow() {
            this.numImmediateSelects = Math.max(0L, this.numImmediateSelects + 1L);
        }

        public Object inspect() {
            long[] data = this.getStats();
            HashMap<String, Number> ret = new HashMap<String, Number>();
            ret.put("ver", 1);
            ret.put("num", data[0]);
            ret.put("numIm", data[1]);
            ret.put("avg", data[2]);
            return ret;
        }
    }

    private class MyTransportListener
    implements TransportListener {
        private MyTransportListener() {
        }

        public void eventPending() {
            NIODispatcher.this.wakeup();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NIOExecutorService
    extends AbstractExecutorService
    implements ScheduledExecutorService {
        private final Thread nioThread;

        private NIOExecutorService(Thread nioThread) {
            this.nioThread = nioThread;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            Thread.sleep(unit.toMillis(timeout));
            return false;
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public boolean isTerminated() {
            return false;
        }

        @Override
        public void shutdown() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Runnable> shutdownNow() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void execute(Runnable command) {
            if (Thread.currentThread() == this.nioThread) {
                command.run();
            } else {
                NIODispatcher.instance().executeLaterAlways(command);
            }
        }

        @Override
        public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            ScheduledFutureTask<Object> ret = new ScheduledFutureTask<Object>(command, null, unit.toNanos(delay));
            NIODispatcher.instance().DELAYED.add(ret);
            NIODispatcher.instance().wakeup();
            return ret;
        }

        @Override
        public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
            ScheduledFutureTask<V> ret = new ScheduledFutureTask<V>(callable, unit.toNanos(delay));
            NIODispatcher.instance().DELAYED.add(ret);
            NIODispatcher.instance().wakeup();
            return ret;
        }

        @Override
        public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }
    }

    private static class ProcessingException
    extends Exception {
        public ProcessingException() {
        }

        public ProcessingException(Throwable t) {
            super(t);
        }
    }

    private static class SpinningException
    extends Exception {
    }

    private class RegisterOp
    implements Runnable {
        private final SelectableChannel channel;
        private final IOErrorObserver handler;
        private final int op;
        private final int timeout;

        RegisterOp(SelectableChannel channel, IOErrorObserver handler, int op, int timeout) {
            this.channel = channel;
            this.handler = handler;
            this.op = op;
            this.timeout = timeout;
        }

        public void run() {
            NIODispatcher.this.registerImpl(NIODispatcher.this.getSelectorFor(this.channel), this.channel, this.op, this.handler, this.timeout);
        }
    }

    class Attachment
    implements Timeoutable {
        private final IOErrorObserver attachment;
        private long lastMod;
        private int handled;
        private SelectionKey key;
        private boolean timeoutActive = false;
        private long storedTimeoutLength = Long.MAX_VALUE;
        private long storedExpireTime = Long.MAX_VALUE;
        private volatile boolean discarded;

        Attachment(IOErrorObserver attachment) {
            this.attachment = attachment;
        }

        public String toString() {
            return "Attachment for: " + this.attachment;
        }

        void discard() {
            this.discarded = true;
        }

        synchronized void clearTimeout() {
            this.timeoutActive = false;
        }

        synchronized void updateReadTimeout(long now) {
            if (!this.discarded && this.attachment instanceof ReadTimeout) {
                long timeoutLength = ((ReadTimeout)((Object)this.attachment)).getReadTimeout();
                if (timeoutLength != 0L) {
                    long expireTime = now + timeoutLength;
                    if (expireTime < this.storedExpireTime || this.storedExpireTime == -1L || this.storedExpireTime < now) {
                        this.addTimeout(now, timeoutLength);
                    } else {
                        this.storedExpireTime = expireTime;
                        this.storedTimeoutLength = timeoutLength;
                        this.timeoutActive = true;
                    }
                } else {
                    this.clearTimeout();
                }
            }
        }

        synchronized void changeReadStatus(boolean reading) {
            if (!this.discarded) {
                if (reading) {
                    this.updateReadTimeout(System.currentTimeMillis());
                } else {
                    this.clearTimeout();
                }
            }
        }

        synchronized void addTimeout(long now, long timeoutLength) {
            if (!this.discarded) {
                this.timeoutActive = true;
                this.storedTimeoutLength = timeoutLength;
                this.storedExpireTime = now + timeoutLength;
                NIODispatcher.this.TIMEOUTER.addTimeout(this, now, timeoutLength);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyTimeout(long now, long expireTime, long timeoutLength) {
            if (!this.discarded) {
                boolean cancel = false;
                long timeToUse = 0L;
                Attachment attachment = this;
                synchronized (attachment) {
                    if (this.timeoutActive) {
                        if (expireTime == this.storedExpireTime) {
                            cancel = true;
                            this.timeoutActive = false;
                            timeToUse = this.storedTimeoutLength;
                            this.storedExpireTime = -1L;
                        } else if (expireTime < this.storedExpireTime) {
                            NIODispatcher.this.TIMEOUTER.addTimeout(this, now, this.storedExpireTime - now);
                        } else {
                            this.storedExpireTime = -1L;
                            if (LOG.isWarnEnabled()) {
                                LOG.warn("Ignoring extra timeout for: " + this.attachment);
                            }
                        }
                    } else {
                        this.storedExpireTime = -1L;
                        this.storedTimeoutLength = -1L;
                    }
                }
                if (cancel) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Closing due to read timeout: " + this.attachment);
                    }
                    NIODispatcher.this.cancel(this.key, this.attachment);
                    this.attachment.handleIOException(new SocketTimeoutException("operation timed out (" + timeToUse + ")"));
                }
            }
        }

        public void setKey(SelectionKey key) {
            this.key = key;
        }
    }
}

