/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import org.limewire.nio.BufferInputStream;
import org.limewire.nio.NIODispatcher;
import org.limewire.nio.channel.ChannelReadObserver;
import org.limewire.nio.channel.InterestReadableByteChannel;
import org.limewire.nio.channel.InterestScatteringByteChannel;
import org.limewire.nio.observer.Shutdownable;
import org.limewire.nio.timeout.ReadTimeout;
import org.limewire.nio.timeout.SoTimeout;
import org.limewire.util.BufferUtils;

class NIOInputStream
implements ChannelReadObserver,
InterestScatteringByteChannel,
ReadTimeout {
    private final Shutdownable shutdownHandler;
    private final SoTimeout soTimeoutHandler;
    private InterestReadableByteChannel channel;
    private BufferInputStream source;
    private volatile Object bufferLock;
    private ByteBuffer buffer;
    private boolean shutdown;
    private boolean lastFilled = false;

    NIOInputStream(SoTimeout soTimeouter, Shutdownable shutdowner, InterestReadableByteChannel channel) {
        this.soTimeoutHandler = soTimeouter;
        this.shutdownHandler = shutdowner;
        this.channel = channel;
    }

    synchronized NIOInputStream init() throws IOException {
        if (this.buffer != null) {
            throw new IllegalStateException("already init'd!");
        }
        if (this.shutdown) {
            throw new IOException("Already closed!");
        }
        this.buffer = NIODispatcher.instance().getBufferCache().getHeap();
        this.source = new BufferInputStream(this.buffer, this, this.shutdownHandler, this.channel, this);
        this.bufferLock = this.source.getBufferLock();
        return this;
    }

    public int read(ByteBuffer toBuffer) {
        return BufferUtils.transfer(this.buffer, toBuffer);
    }

    public long read(ByteBuffer[] dst, int offset, int length) {
        return BufferUtils.transfer(this.buffer, dst, offset, length, true);
    }

    public long read(ByteBuffer[] dst) {
        return this.read(dst, 0, dst.length);
    }

    synchronized InputStream getInputStream() throws IOException {
        if (this.buffer == null) {
            this.init();
        }
        return this.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRead() throws IOException {
        if (this.bufferLock == null) {
            int read = this.channel.read(BufferUtils.getEmptyBuffer());
            if (read == -1) {
                throw new ClosedChannelException();
            }
        } else {
            Object object = this.bufferLock;
            synchronized (object) {
                int read = 0;
                while (this.buffer.hasRemaining() && (read = this.channel.read(this.buffer)) > 0) {
                }
                if (read == -1) {
                    this.source.finished();
                }
                if (this.buffer.position() > 0 || read == -1) {
                    this.bufferLock.notify();
                }
                if (!this.buffer.hasRemaining()) {
                    this.lastFilled = true;
                    this.channel.interestRead(false);
                } else {
                    this.lastFilled = false;
                }
                if (read == -1) {
                    this.channel.interestRead(false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readHappening() {
        Object object = this.bufferLock;
        synchronized (object) {
            if (this.lastFilled) {
                NIODispatcher.instance().getScheduledExecutorService().execute(new Runnable(){

                    public void run() {
                        try {
                            NIOInputStream.this.handleRead();
                        }
                        catch (IOException iox) {
                            NIOInputStream.this.channel.interestRead(true);
                            NIOInputStream.this.shutdownHandler.shutdown();
                        }
                    }
                });
            }
        }
    }

    public synchronized void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        if (this.source != null) {
            this.source.shutdown();
        }
        if (this.buffer != null) {
            NIODispatcher.instance().getScheduledExecutorService().execute(new Runnable(){

                public void run() {
                    NIODispatcher.instance().getBufferCache().release(NIOInputStream.this.buffer);
                }
            });
        }
    }

    public void handleIOException(IOException iox) {
        throw new RuntimeException("unsupported operation", iox);
    }

    public void close() throws IOException {
    }

    public boolean isOpen() {
        return true;
    }

    public void interestRead(boolean status) {
        this.channel.interestRead(status);
    }

    public InterestReadableByteChannel getReadChannel() {
        return this.channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReadChannel(InterestReadableByteChannel newChannel) {
        Object object = this.bufferLock;
        synchronized (object) {
            this.channel = newChannel;
            this.source.setReadChannel(newChannel);
        }
    }

    public long getReadTimeout() {
        try {
            return this.soTimeoutHandler.getSoTimeout();
        }
        catch (SocketException se) {
            return -1L;
        }
    }
}

