/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import org.limewire.nio.NIODispatcher;
import org.limewire.nio.channel.InterestScatteringByteChannel;

class SocketInterestReadAdapter
implements InterestScatteringByteChannel {
    private static final IOException OOM = new IOException("Out Of Memory");
    private SocketChannel channel;

    SocketInterestReadAdapter(SocketChannel channel) {
        this.channel = channel;
    }

    public void interestRead(boolean status) {
        NIODispatcher.instance().interestRead(this.channel, status);
    }

    public int read(ByteBuffer dst) throws IOException {
        try {
            return this.channel.read(dst);
        }
        catch (OutOfMemoryError oom) {
            System.gc();
            throw OOM;
        }
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public void close() throws IOException {
        this.channel.close();
    }

    ReadableByteChannel getChannel() {
        return this.channel;
    }

    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return this.channel.read(dsts, offset, length);
    }

    public long read(ByteBuffer[] dsts) throws IOException {
        return this.channel.read(dsts);
    }

    public String toString() {
        return "SocketInterestReadAdapter: " + this.channel;
    }
}

