/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio.channel;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.limewire.nio.channel.ChannelReadObserver;
import org.limewire.nio.channel.InterestReadableByteChannel;
import org.limewire.nio.channel.InterestScatteringByteChannel;
import org.limewire.util.BufferUtils;

public abstract class AbstractChannelInterestReader
implements ChannelReadObserver,
InterestScatteringByteChannel {
    protected ByteBuffer buffer;
    protected InterestReadableByteChannel source;
    protected boolean shutdown;

    public AbstractChannelInterestReader(int bufferSize) {
        this.buffer = ByteBuffer.allocate(bufferSize);
    }

    public int read(ByteBuffer dst) {
        return BufferUtils.transfer(this.buffer, dst);
    }

    public long read(ByteBuffer[] dst) {
        return this.read(dst, 0, dst.length);
    }

    public long read(ByteBuffer[] dst, int offset, int length) {
        return BufferUtils.transfer(this.buffer, dst, offset, length, true);
    }

    public void shutdown() {
        this.shutdown = true;
    }

    public InterestReadableByteChannel getReadChannel() {
        return this.source;
    }

    public void setReadChannel(InterestReadableByteChannel newChannel) {
        this.source = newChannel;
    }

    public void interestRead(boolean status) {
        this.source.interestRead(status);
    }

    public void close() throws IOException {
        this.source.close();
    }

    public boolean isOpen() {
        return this.source.isOpen();
    }

    public void handleIOException(IOException iox) {
    }
}

