/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio.channel;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.limewire.nio.channel.ChannelWriter;
import org.limewire.nio.channel.InterestWritableByteChannel;
import org.limewire.nio.observer.WriteObserver;

public abstract class AbstractChannelInterestWriter
implements ChannelWriter,
InterestWritableByteChannel {
    private volatile InterestWritableByteChannel channel;
    private volatile WriteObserver observer;

    public InterestWritableByteChannel getWriteChannel() {
        return this.channel;
    }

    public void setWriteChannel(InterestWritableByteChannel channel) {
        this.channel = channel;
        channel.interestWrite(this, true);
    }

    public void interestWrite(WriteObserver observer, boolean status) {
        this.observer = status ? observer : null;
        InterestWritableByteChannel source = this.channel;
        if (source != null) {
            source.interestWrite(this, status);
        }
    }

    public void close() throws IOException {
        InterestWritableByteChannel source = this.channel;
        if (source != null) {
            source.close();
        }
    }

    public boolean isOpen() {
        InterestWritableByteChannel source = this.channel;
        return source != null ? source.isOpen() : false;
    }

    public void shutdown() {
        WriteObserver listener = this.observer;
        if (listener != null) {
            listener.shutdown();
        }
    }

    public void handleIOException(IOException x) {
        throw new RuntimeException("Unsupported", x);
    }

    public boolean hasBufferedOutput() {
        InterestWritableByteChannel channel = this.channel;
        return channel != null && channel.hasBufferedOutput();
    }

    public boolean handleWrite() throws IOException {
        WriteObserver interested = this.observer;
        if (interested != null) {
            return interested.handleWrite();
        }
        return false;
    }

    public int write(ByteBuffer src) throws IOException {
        InterestWritableByteChannel source = this.channel;
        if (source == null) {
            throw new IllegalStateException("no source!");
        }
        return source.write(src);
    }
}

