/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio.channel;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.Periodic;
import org.limewire.nio.NIODispatcher;
import org.limewire.nio.channel.ChannelWriter;
import org.limewire.nio.channel.InterestWritableByteChannel;
import org.limewire.nio.observer.WriteObserver;

public class DelayedBufferWriter
implements ChannelWriter,
InterestWritableByteChannel {
    private static final Log LOG = LogFactory.getLog(DelayedBufferWriter.class);
    private static final int DEFAULT_DELAY = 200;
    private volatile InterestWritableByteChannel sink;
    private volatile WriteObserver observer;
    private final ByteBuffer buf;
    private final long delay;
    private final Periodic interester;
    private long lastFlushTime;

    public DelayedBufferWriter(int size) {
        this(size, 200L);
    }

    public DelayedBufferWriter(int size, long delay) {
        this(size, delay, NIODispatcher.instance().getScheduledExecutorService());
    }

    DelayedBufferWriter(int size, long delay, ScheduledExecutorService scheduler) {
        this.buf = ByteBuffer.allocate(size);
        this.delay = TimeUnit.MILLISECONDS.toNanos(delay);
        this.interester = new Periodic(new Interester(), scheduler);
    }

    public synchronized void interestWrite(WriteObserver observer, boolean status) {
        if (status) {
            this.observer = observer;
            this.interester.unschedule();
            LOG.debug("cancelling scheduled flush");
        } else {
            this.observer = null;
        }
        InterestWritableByteChannel source = this.sink;
        if (source != null) {
            source.interestWrite(this, true);
        }
    }

    public void close() throws IOException {
        InterestWritableByteChannel chan = this.sink;
        if (chan != null) {
            chan.close();
        }
    }

    public boolean isOpen() {
        InterestWritableByteChannel chan = this.sink;
        return chan != null ? chan.isOpen() : false;
    }

    public InterestWritableByteChannel getWriteChannel() {
        return this.sink;
    }

    public void setWriteChannel(InterestWritableByteChannel newChannel) {
        this.sink = newChannel;
        newChannel.interestWrite(this, true);
    }

    public void handleIOException(IOException iox) {
        throw new RuntimeException("Unsupported", iox);
    }

    public void shutdown() {
        WriteObserver listener = this.observer;
        if (listener != null) {
            listener.shutdown();
        }
    }

    public int write(ByteBuffer buffer) throws IOException {
        int originalPos = buffer.position();
        while (buffer.hasRemaining()) {
            if (this.buf.hasRemaining()) {
                int adding;
                int remaining = this.buf.remaining();
                if (remaining >= (adding = buffer.remaining())) {
                    this.buf.put(buffer);
                    continue;
                }
                int oldLimit = buffer.limit();
                int position = buffer.position();
                buffer.limit(position + remaining);
                this.buf.put(buffer);
                buffer.limit(oldLimit);
                continue;
            }
            this.flush(System.nanoTime());
            if (this.buf.hasRemaining()) continue;
            break;
        }
        return buffer.position() - originalPos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleWrite() throws IOException {
        WriteObserver upper = this.observer;
        if (upper != null) {
            upper.handleWrite();
        }
        long now = System.nanoTime();
        if (this.lastFlushTime == 0L) {
            this.lastFlushTime = now;
        }
        if (now - this.lastFlushTime > this.delay) {
            this.flush(now);
        }
        DelayedBufferWriter delayedBufferWriter = this;
        synchronized (delayedBufferWriter) {
            upper = this.observer;
            if (upper == null) {
                this.sink.interestWrite(this, false);
                if (!this.hasBufferedData()) {
                    return false;
                }
                this.interester.rescheduleIfLater(TimeUnit.NANOSECONDS.toMillis(this.lastFlushTime + this.delay - now));
            }
        }
        return true;
    }

    public boolean flush() throws IOException {
        this.flush(System.nanoTime());
        return !this.hasBufferedData();
    }

    private void flush(long now) throws IOException {
        this.buf.flip();
        InterestWritableByteChannel chan = this.sink;
        chan.write(this.buf);
        if (this.hasBufferedData()) {
            this.lastFlushTime = now;
            if (this.buf.hasRemaining()) {
                this.buf.compact();
            } else {
                this.buf.clear();
            }
        } else {
            this.buf.position(this.buf.limit()).limit(this.buf.capacity());
        }
    }

    private boolean hasBufferedData() {
        return this.buf.position() > 0;
    }

    public boolean hasBufferedOutput() {
        InterestWritableByteChannel channel = this.sink;
        return this.hasBufferedData() || channel != null && channel.hasBufferedOutput();
    }

    private class Interester
    implements Runnable {
        private Interester() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            DelayedBufferWriter me;
            DelayedBufferWriter delayedBufferWriter = me = DelayedBufferWriter.this;
            synchronized (delayedBufferWriter) {
                InterestWritableByteChannel below = me.sink;
                WriteObserver above = DelayedBufferWriter.this.observer;
                if (below != null && below.isOpen() && above == null && DelayedBufferWriter.this.buf.position() > 0) {
                    LOG.debug("forcing a flush");
                    below.interestWrite(me, true);
                }
            }
        }
    }
}

