/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio.channel;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.limewire.nio.RequiresSelectionKeyAttachment;
import org.limewire.nio.Throttle;
import org.limewire.nio.ThrottleListener;
import org.limewire.nio.channel.ChannelReader;
import org.limewire.nio.channel.InterestReadableByteChannel;
import org.limewire.util.BufferUtils;

public class ThrottleReader
implements InterestReadableByteChannel,
ChannelReader,
RequiresSelectionKeyAttachment {
    private volatile InterestReadableByteChannel channel;
    private final Throttle throttle;
    private int available;
    private volatile boolean lastInterestState;
    private final Listener throttleListener;

    public ThrottleReader(Throttle throttle) {
        this(throttle, null);
    }

    public ThrottleReader(Throttle throttle, InterestReadableByteChannel channel) {
        this.throttle = throttle;
        this.channel = channel;
        this.throttleListener = new Listener();
    }

    public InterestReadableByteChannel getReadChannel() {
        return this.channel;
    }

    public void setReadChannel(InterestReadableByteChannel channel) {
        this.channel = channel;
        this.throttle.interest(this.throttleListener);
    }

    public void interestRead(boolean status) {
        this.lastInterestState = status;
        if (this.channel != null) {
            if (status) {
                this.throttle.interest(this.throttleListener);
            } else {
                this.channel.interestRead(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ByteBuffer buffer) throws IOException {
        InterestReadableByteChannel chain = this.channel;
        if (chain == null) {
            throw new IllegalStateException("reading with no chain!");
        }
        int totalRead = 0;
        if (this.available > 0) {
            int priorLimit = buffer.limit();
            if (buffer.remaining() > this.available) {
                buffer.limit(buffer.position() + this.available);
            }
            try {
                totalRead = this.channel.read(buffer);
            }
            finally {
                buffer.limit(priorLimit);
            }
            if (totalRead > 0) {
                this.available -= totalRead;
            }
        } else {
            this.channel.read(BufferUtils.getEmptyBuffer());
            this.channel.interestRead(false);
            if (this.lastInterestState) {
                this.throttle.interest(this.throttleListener);
            }
        }
        return totalRead;
    }

    public void close() throws IOException {
        InterestReadableByteChannel source = this.channel;
        if (source != null) {
            source.close();
        }
    }

    public boolean isOpen() {
        InterestReadableByteChannel source = this.channel;
        return source != null ? source.isOpen() : false;
    }

    public void setAttachment(Object o) {
        this.throttleListener.setAttachment(o);
    }

    private final class Listener
    implements ThrottleListener {
        private Object attachment;

        private Listener() {
        }

        public boolean bandwidthAvailable() {
            if (ThrottleReader.this.channel.isOpen() && ThrottleReader.this.lastInterestState) {
                ThrottleReader.this.channel.interestRead(true);
                return true;
            }
            return false;
        }

        public boolean isOpen() {
            return ThrottleReader.this.isOpen();
        }

        public void requestBandwidth() {
            ThrottleReader.this.available = ThrottleReader.this.throttle.request();
        }

        public void releaseBandwidth() {
            ThrottleReader.this.throttle.release(ThrottleReader.this.available);
            ThrottleReader.this.available = 0;
            if (ThrottleReader.this.lastInterestState) {
                ThrottleReader.this.throttle.interest(this);
            }
        }

        public void setAttachment(Object att) {
            this.attachment = att;
        }

        public Object getAttachment() {
            return this.attachment;
        }
    }
}

