/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio.ssl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.nio.ByteBufferCache;
import org.limewire.nio.channel.ChannelReader;
import org.limewire.nio.channel.ChannelWriter;
import org.limewire.nio.channel.InterestReadableByteChannel;
import org.limewire.nio.channel.InterestWritableByteChannel;
import org.limewire.nio.observer.WriteObserver;
import org.limewire.util.BufferUtils;
import org.limewire.util.FileUtils;

class SSLReadWriteChannel
implements InterestReadableByteChannel,
InterestWritableByteChannel,
ChannelReader,
ChannelWriter {
    private static final Log LOG = LogFactory.getLog(SSLReadWriteChannel.class);
    private final SSLContext context;
    private final Executor sslBlockingExecutor;
    private SSLEngine engine;
    private ByteBuffer readIncoming;
    private ByteBuffer readOutgoing;
    private ByteBuffer writeOutgoing;
    private volatile InterestReadableByteChannel readSink;
    private volatile InterestWritableByteChannel writeSink;
    private volatile WriteObserver writeWanter;
    private volatile boolean needsHandshakeWrap = false;
    private volatile boolean needsHandshakeUnwrap = false;
    private volatile boolean readDataLeft = false;
    private final AtomicBoolean firstReadDone = new AtomicBoolean(false);
    private volatile long readConsumed;
    private volatile long readProduced;
    private volatile long writeConsumed;
    private volatile long writeProduced;
    private volatile boolean shutdown = false;
    private final Object initLock = new Object();
    private final Object taskLock = new Object();
    private volatile boolean taskScheduled = false;
    private boolean readInterest = false;
    private final Object readInterestLock = new Object();
    private final ByteBufferCache byteBufferCache;
    private final Executor networkExecutor;

    public SSLReadWriteChannel(SSLContext context, Executor sslBlockingExecutor, ByteBufferCache byteBufferCache, Executor networkExecutor) {
        this.sslBlockingExecutor = sslBlockingExecutor;
        this.context = context;
        this.byteBufferCache = byteBufferCache;
        this.networkExecutor = networkExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialize(SocketAddress addr, String[] cipherSuites, boolean clientMode, boolean needClientAuth) {
        Object object = this.initLock;
        synchronized (object) {
            if (this.shutdown) {
                LOG.debug("Not initializing because already shutdown.");
                return;
            }
            if (addr != null) {
                if (!(addr instanceof InetSocketAddress)) {
                    throw new IllegalArgumentException("unsupported SocketAddress");
                }
                InetSocketAddress iaddr = (InetSocketAddress)addr;
                String host = iaddr.getAddress().getHostAddress();
                int port = iaddr.getPort();
                this.engine = this.context.createSSLEngine(host, port);
            } else {
                this.engine = this.context.createSSLEngine();
            }
            this.engine.setEnabledCipherSuites(cipherSuites);
            this.engine.setUseClientMode(clientMode);
            if (!clientMode) {
                this.engine.setWantClientAuth(needClientAuth);
                this.engine.setNeedClientAuth(needClientAuth);
            }
            SSLSession session = this.engine.getSession();
            this.readIncoming = this.byteBufferCache.getHeap(session.getPacketBufferSize());
            this.writeOutgoing = this.byteBufferCache.getHeap(session.getPacketBufferSize());
            if (LOG.isTraceEnabled()) {
                LOG.trace("Initialized engine: " + this.engine + ", session: " + session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ByteBuffer dst) throws IOException {
        SSLEngineResult result;
        if (this.shutdown) {
            throw new ClosedChannelException();
        }
        if (this.taskScheduled) {
            return 0;
        }
        int transferred = 0;
        if (this.readOutgoing != null && this.readOutgoing.position() > 0) {
            transferred += BufferUtils.transfer(this.readOutgoing, dst);
            if (this.readOutgoing.hasRemaining()) {
                LOG.debug("Transferred less than we have left!");
                return transferred;
            }
        }
        do {
            if (this.firstReadDone.get() && !dst.hasRemaining() && this.engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                LOG.debug("No room left to transfer data, exiting");
                return transferred;
            }
            int read = -1;
            while (this.readIncoming.hasRemaining() && (read = this.readSink.read(this.readIncoming)) > 0) {
            }
            if (read == -1 && this.readIncoming.position() == 0) {
                LOG.debug("Read EOF, no data to transfer.  Connection finished");
                return -1;
            }
            if (this.readIncoming.position() == 0) {
                LOG.debug("Unable to read anything, exiting read loop");
                return 0;
            }
            this.readIncoming.flip();
            result = this.engine.unwrap(this.readIncoming, dst);
            this.readProduced += (long)result.bytesProduced();
            this.readConsumed += (long)result.bytesConsumed();
            transferred += result.bytesProduced();
            SSLEngineResult.Status status = result.getStatus();
            if (status == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                Object object;
                if (this.readOutgoing == null) {
                    object = this.initLock;
                    synchronized (object) {
                        if (this.shutdown) {
                            throw new IOException("Shutdown while sizing");
                        }
                        this.readOutgoing = this.byteBufferCache.getHeap(this.engine.getSession().getApplicationBufferSize());
                    }
                }
                result = this.engine.unwrap(this.readIncoming, this.readOutgoing);
                this.readProduced += (long)result.bytesProduced();
                this.readConsumed += (long)result.bytesConsumed();
                status = result.getStatus();
                if (status == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                    if (this.readIncoming.position() == 0 && this.readIncoming.capacity() == 16665 && this.engine.getSession().getPacketBufferSize() == 33049) {
                        object = this.initLock;
                        synchronized (object) {
                            if (this.shutdown) {
                                throw new IOException("Shutdown while resizing.");
                            }
                            ByteBuffer newIncoming = this.byteBufferCache.getHeap(this.engine.getSession().getPacketBufferSize());
                            BufferUtils.transfer(this.readIncoming, newIncoming, false);
                            newIncoming.flip();
                            assert (newIncoming.limit() == this.readIncoming.position());
                            assert (newIncoming.position() == 0);
                            this.byteBufferCache.release(this.readIncoming);
                            this.readIncoming = newIncoming;
                            assert (this.readOutgoing.position() == 0);
                            this.byteBufferCache.release(this.readOutgoing);
                            this.readOutgoing = this.byteBufferCache.getHeap(this.engine.getSession().getApplicationBufferSize());
                            result = this.engine.unwrap(this.readIncoming, this.readOutgoing);
                            this.readProduced += (long)result.bytesProduced();
                            this.readConsumed += (long)result.bytesConsumed();
                            status = result.getStatus();
                            if (status == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                                throw new IllegalStateException("tried resizing, but still not enough room in fallback TLS buffer!  readOutgoing: " + this.readOutgoing + ", readIncoming: " + this.readIncoming + ", packet size: " + this.engine.getSession().getPacketBufferSize() + ", appl size: " + this.engine.getSession().getApplicationBufferSize());
                            }
                        }
                    } else {
                        throw new IllegalStateException("cannot resize, and not enough room in fallback TLS buffer!  readOutgoing: " + this.readOutgoing + ", readIncoming: " + this.readIncoming + ", packet size: " + this.engine.getSession().getPacketBufferSize() + ", appl size: " + this.engine.getSession().getApplicationBufferSize());
                    }
                }
                transferred += BufferUtils.transfer(this.readOutgoing, dst);
            }
            this.firstReadDone.set(true);
            if (this.readIncoming.hasRemaining()) {
                this.readDataLeft = true;
                this.readIncoming.compact();
            } else {
                this.readDataLeft = false;
                this.readIncoming.clear();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Read unwrap result: " + result + ", transferred: " + transferred);
            }
            if (status == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                if (transferred == 0 && read == -1) {
                    LOG.debug("Read EOF & underflow when unwrapping.  Connection finished");
                    return -1;
                }
                return transferred;
            }
            if (status != SSLEngineResult.Status.CLOSED) continue;
            if (transferred == 0) {
                return -1;
            }
            return transferred;
        } while (this.processHandshakeResult(true, false, result.getHandshakeStatus()));
        return transferred;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processHandshakeResult(boolean reading, boolean writing, SSLEngineResult.HandshakeStatus hs) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Processing result from: " + this.engine + ", result: " + (Object)((Object)hs));
        }
        this.needsHandshakeWrap = false;
        this.needsHandshakeUnwrap = false;
        switch (hs) {
            case NEED_TASK: {
                this.needTask();
                return false;
            }
            case NEED_WRAP: {
                this.needsHandshakeWrap = true;
                this.readSink.interestRead(false);
                this.writeSink.interestWrite(this, true);
                return writing;
            }
            case NEED_UNWRAP: {
                this.writeSink.interestWrite(null, false);
                Object object = this.readInterestLock;
                synchronized (object) {
                    this.needsHandshakeUnwrap = true;
                    this.readSink.interestRead(true);
                }
                if (this.readDataLeft && !reading) {
                    this.networkExecutor.execute(new Runnable(){

                        public void run() {
                            try {
                                SSLReadWriteChannel.this.read(BufferUtils.getEmptyBuffer());
                            }
                            catch (IOException iox) {
                                FileUtils.close(SSLReadWriteChannel.this);
                            }
                        }
                    });
                }
                return reading;
            }
            case FINISHED: {
                Object object = this.readInterestLock;
                synchronized (object) {
                    this.readSink.interestRead(this.readInterest);
                }
                this.writeSink.interestWrite(this, true);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void needTask() {
        Object object = this.taskLock;
        synchronized (object) {
            this.taskScheduled = true;
            this.readSink.interestRead(false);
            this.writeSink.interestWrite(null, false);
        }
        while (true) {
            Runnable runner;
            if ((runner = this.engine.getDelegatedTask()) == null) break;
            this.sslBlockingExecutor.execute(runner);
        }
        this.sslBlockingExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = SSLReadWriteChannel.this.taskLock;
                synchronized (object) {
                    SSLReadWriteChannel.this.taskScheduled = false;
                }
                SSLEngineResult.HandshakeStatus status = SSLReadWriteChannel.this.engine.getHandshakeStatus();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Task(s) finished, status: " + (Object)((Object)status));
                }
                SSLReadWriteChannel.this.processHandshakeResult(false, false, status);
            }
        });
    }

    public int write(ByteBuffer src) throws IOException {
        if (this.shutdown) {
            throw new ClosedChannelException();
        }
        if (this.taskScheduled) {
            return 0;
        }
        int consumed = 0;
        do {
            boolean wasEmpty = this.writeOutgoing.position() == 0;
            SSLEngineResult result = this.engine.wrap(src, this.writeOutgoing);
            this.writeProduced += (long)result.bytesProduced();
            this.writeConsumed += (long)result.bytesConsumed();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Wrap result: " + result);
            }
            consumed += result.bytesConsumed();
            SSLEngineResult.Status status = result.getStatus();
            if (status == SSLEngineResult.Status.CLOSED && !this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (!this.processHandshakeResult(false, true, result.getHandshakeStatus())) break;
            if (status != SSLEngineResult.Status.BUFFER_OVERFLOW) continue;
            if (!wasEmpty) break;
            throw new IllegalStateException("outgoing TLS buffer not large enough!");
        } while (src.hasRemaining());
        return consumed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleWrite() throws IOException {
        if (this.shutdown) {
            throw new ClosedChannelException();
        }
        InterestWritableByteChannel source = this.writeSink;
        if (source == null) {
            throw new IllegalStateException("writing with no source.");
        }
        while (true) {
            WriteObserver interested;
            if (this.writeOutgoing.position() > 0) {
                this.writeOutgoing.flip();
                this.writeSink.write(this.writeOutgoing);
                if (this.writeOutgoing.hasRemaining()) {
                    this.writeOutgoing.compact();
                    return true;
                }
                this.writeOutgoing.clear();
            }
            if (this.needsHandshakeWrap) {
                LOG.debug("Forcing a handshake wrap");
                this.write(BufferUtils.getEmptyBuffer());
                if (this.writeOutgoing.position() > 0) continue;
            }
            if ((interested = this.writeWanter) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Telling interested parties to write.  (a " + interested + ")");
                }
                interested.handleWrite();
            }
            if (this.writeOutgoing.position() == 0) break;
        }
        SSLReadWriteChannel sSLReadWriteChannel = this;
        synchronized (sSLReadWriteChannel) {
            if (this.writeWanter == null) {
                source.interestWrite(this, false);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        WriteObserver observer;
        Object object = this.initLock;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            if (!this.isOpen()) {
                LOG.debug("Shutting down SSL channel");
                this.shutdown = true;
            }
        }
        if (this.shutdown) {
            this.networkExecutor.execute(new Runnable(){

                public void run() {
                    if (SSLReadWriteChannel.this.readIncoming != null) {
                        SSLReadWriteChannel.this.byteBufferCache.release(SSLReadWriteChannel.this.readIncoming);
                    }
                    if (SSLReadWriteChannel.this.readOutgoing != null) {
                        SSLReadWriteChannel.this.byteBufferCache.release(SSLReadWriteChannel.this.readOutgoing);
                    }
                    if (SSLReadWriteChannel.this.writeOutgoing != null) {
                        SSLReadWriteChannel.this.byteBufferCache.release(SSLReadWriteChannel.this.writeOutgoing);
                    }
                }
            });
        }
        if ((observer = this.writeWanter) != null) {
            observer.shutdown();
        }
    }

    public InterestReadableByteChannel getReadChannel() {
        return this.readSink;
    }

    public void setReadChannel(InterestReadableByteChannel newChannel) {
        this.readSink = newChannel;
    }

    public InterestWritableByteChannel getWriteChannel() {
        return this.writeSink;
    }

    public void setWriteChannel(InterestWritableByteChannel newChannel) {
        this.writeSink = newChannel;
    }

    public void close() throws IOException {
        this.readSink.close();
        this.writeSink.close();
    }

    public boolean isOpen() {
        return this.readSink != null && this.readSink.isOpen() && this.writeSink != null && this.writeSink.isOpen();
    }

    public void handleIOException(IOException iox) {
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interestRead(boolean status) {
        Object object = this.taskLock;
        synchronized (object) {
            Object object2 = this.readInterestLock;
            synchronized (object2) {
                this.readInterest = status;
                boolean interest = !this.taskScheduled && (this.needsHandshakeUnwrap || status);
                this.readSink.interestRead(interest);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void interestWrite(WriteObserver observer, boolean status) {
        this.writeWanter = status ? observer : null;
        InterestWritableByteChannel source = this.writeSink;
        if (source != null) {
            Object object = this.taskLock;
            synchronized (object) {
                source.interestWrite(this, !this.taskScheduled);
            }
        }
    }

    long getReadBytesProduced() {
        return this.readProduced;
    }

    long getReadBytesConsumed() {
        return this.readConsumed;
    }

    long getWrittenBytesProduced() {
        return this.writeProduced;
    }

    long getWrittenBytesConsumed() {
        return this.writeConsumed;
    }

    SSLSession getSession() {
        return this.engine != null ? this.engine.getSession() : null;
    }

    boolean isHandshaking() {
        return !this.firstReadDone.get() || this.engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    }

    public boolean hasBufferedOutput() {
        InterestWritableByteChannel channel = this.writeSink;
        return this.writeOutgoing.position() > 0 || channel != null && channel.hasBufferedOutput();
    }
}

