/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.promotion;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.limewire.io.BadGGEPBlockException;
import org.limewire.promotion.containers.BucketMessageContainer;
import org.limewire.promotion.containers.MessageContainer;
import org.limewire.promotion.containers.MessageContainerParser;
import org.limewire.promotion.containers.PromotionMessageContainer;
import org.limewire.promotion.containers.SignedMessageContainer;
import org.limewire.promotion.exceptions.PromotionException;
import org.limewire.security.certificate.CertificateVerifier;
import org.limewire.security.certificate.CipherProvider;
import org.limewire.security.certificate.KeyStoreProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PromotionBinder {
    private CipherProvider cipherProvider;
    private KeyStoreProvider keyStore;
    private CertificateVerifier certificateVerifier;
    private SignedMessageContainer backingSignedMessage = null;
    private List<PromotionMessageContainer> promoMessageList = null;
    private String uniqueName = System.currentTimeMillis() + "";
    private int bucketNumber = -1;
    private Date validEnd = new Date();

    @Inject
    public PromotionBinder(CipherProvider cipherProvider, KeyStoreProvider keyStore, CertificateVerifier certificateVerifier) {
        this.cipherProvider = cipherProvider;
        this.keyStore = keyStore;
        this.certificateVerifier = certificateVerifier;
    }

    public void initialize(byte[] encodedBinder) throws PromotionException {
        MessageContainer message;
        this.backingSignedMessage = null;
        MessageContainerParser parser = new MessageContainerParser();
        try {
            message = parser.parse(encodedBinder);
        }
        catch (BadGGEPBlockException ex) {
            throw new PromotionException("GGEP block exception during parsing.", ex);
        }
        if (!(message instanceof SignedMessageContainer)) {
            throw new PromotionException("Encoded message is not signed.");
        }
        this.initialize((SignedMessageContainer)message);
    }

    public void initialize(SignedMessageContainer signedMessage) throws PromotionException {
        MessageContainer wrappedMessage;
        this.backingSignedMessage = null;
        long currentTimeMillis = System.currentTimeMillis();
        try {
            wrappedMessage = signedMessage.getAndVerifyWrappedMessage(this.cipherProvider, this.keyStore, this.certificateVerifier);
        }
        catch (IOException ex) {
            throw new PromotionException("Failed signature verification. ", ex);
        }
        if (!(wrappedMessage instanceof BucketMessageContainer)) {
            throw new PromotionException("Message signature passed, but did not contain expected bucket.");
        }
        BucketMessageContainer bucket = (BucketMessageContainer)wrappedMessage;
        if (bucket.getValidStart().getTime() > currentTimeMillis) {
            throw new PromotionException("Bucket '" + bucket.getName() + "' is not yet valid.");
        }
        if (bucket.getValidEnd().getTime() < currentTimeMillis) {
            throw new PromotionException("Bucket '" + bucket.getName() + "' has expired.");
        }
        if (bucket.getPromoMessages().size() == 0) {
            throw new PromotionException("Bucket '" + bucket.getName() + "' has no messages.");
        }
        this.uniqueName = bucket.getName();
        this.bucketNumber = bucket.getBucketNumber();
        this.validEnd = bucket.getValidEnd();
        List<PromotionMessageContainer> promos = bucket.getPromoMessages();
        this.promoMessageList = new ArrayList<PromotionMessageContainer>();
        for (PromotionMessageContainer message : promos) {
            if (bucket.getValidStart().getTime() > message.getValidStart().getTime()) {
                message.setValidStart(bucket.getValidStart());
            }
            if (bucket.getValidEnd().getTime() < message.getValidEnd().getTime()) {
                message.setValidEnd(bucket.getValidEnd());
            }
            if (this.isExpired(message, currentTimeMillis)) continue;
            this.promoMessageList.add(message);
        }
        this.backingSignedMessage = signedMessage;
    }

    public List<PromotionMessageContainer> getPromoMessageList() {
        return new ArrayList<PromotionMessageContainer>(this.promoMessageList);
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public int getBucketNumber() {
        return this.bucketNumber;
    }

    public Date getValidEnd() {
        return this.validEnd;
    }

    public byte[] getEncoded() {
        return this.backingSignedMessage.encode();
    }

    private boolean isExpired(PromotionMessageContainer message, long currentTimeMillis) {
        return message.getValidStart().getTime() > currentTimeMillis || message.getValidEnd().getTime() < currentTimeMillis;
    }

    public boolean isValidMember(PromotionMessageContainer message, boolean reverifySignature, long currentTimeMillis) {
        MessageContainer wrappedMessage;
        if (this.isExpired(message, currentTimeMillis)) {
            return false;
        }
        if (!reverifySignature) {
            return this.isValidMember(message, this.promoMessageList, currentTimeMillis);
        }
        try {
            wrappedMessage = this.backingSignedMessage.getAndVerifyWrappedMessage(this.cipherProvider, this.keyStore, this.certificateVerifier);
        }
        catch (IOException ex) {
            return false;
        }
        if (!(wrappedMessage instanceof BucketMessageContainer)) {
            return false;
        }
        BucketMessageContainer bucket = (BucketMessageContainer)wrappedMessage;
        return this.isValidMember(message, bucket.getWrappedMessages(), currentTimeMillis);
    }

    private boolean isValidMember(PromotionMessageContainer message, List<? extends MessageContainer> list, long currentTimeMillis) {
        if (this.isExpired(message, currentTimeMillis)) {
            return false;
        }
        for (MessageContainer messageContainer : list) {
            if (!messageContainer.equals(message)) continue;
            return true;
        }
        return false;
    }
}

