/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.promotion;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.IOUtils;
import org.limewire.promotion.PromotionBinder;
import org.limewire.promotion.PromotionBinderFactory;
import org.limewire.promotion.exceptions.PromotionException;
import org.limewire.security.certificate.CertificateVerifier;
import org.limewire.security.certificate.CipherProvider;
import org.limewire.security.certificate.KeyStoreProvider;

@Singleton
public class PromotionBinderFactoryImpl
implements PromotionBinderFactory {
    private static final Log LOG = LogFactory.getLog(PromotionBinderFactoryImpl.class);
    private CipherProvider cipherProvider;
    private KeyStoreProvider keyStore;
    private CertificateVerifier certificateVerifier;

    @Inject
    public PromotionBinderFactoryImpl(CipherProvider cipherProvider, KeyStoreProvider keyStore, CertificateVerifier certificateVerifier) {
        this.cipherProvider = cipherProvider;
        this.keyStore = keyStore;
        this.certificateVerifier = certificateVerifier;
    }

    public PromotionBinder newBinder(InputStream in) {
        if (in == null) {
            return null;
        }
        PromotionBinder binder = new PromotionBinder(this.cipherProvider, this.keyStore, this.certificateVerifier);
        try {
            binder.initialize(IOUtils.readFully(in));
            return binder;
        }
        catch (PromotionException e) {
            LOG.error(e);
        }
        catch (IOException e) {
            LOG.error(e);
        }
        return null;
    }
}

