/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.promotion.containers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.limewire.promotion.containers.MessageContainer;
import org.limewire.promotion.containers.MultiMessageContainer;
import org.limewire.promotion.containers.PromotionMessageContainer;
import org.limewire.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BucketMessageContainer
extends MultiMessageContainer {
    private static final String KEY_VALID_START = "vs";
    private static final String KEY_VALID_END = "ve";
    private static final String KEY_NAME = "vn";
    private static final String KEY_BUCKET_NUMBER = "vu";

    @Override
    public byte[] getType() {
        return StringUtils.toUTF8Bytes("BKIT");
    }

    public void setName(String bucketName) {
        this.put(KEY_NAME, bucketName);
    }

    public String getName() {
        String name = this.getString(KEY_NAME);
        if (name == null) {
            this.setName(System.currentTimeMillis() / 1000L + "");
            return this.getName();
        }
        return name;
    }

    public void setValidStart(Date date) {
        this.put(KEY_VALID_START, date);
    }

    public Date getValidStart() {
        Date date = this.getDate(KEY_VALID_START);
        if (date == null) {
            return new Date(Long.MAX_VALUE);
        }
        return date;
    }

    public void setValidEnd(Date date) {
        this.put(KEY_VALID_END, date);
    }

    public Date getValidEnd() {
        Date date = this.getDate(KEY_VALID_END);
        if (date == null) {
            return new Date(0L);
        }
        return date;
    }

    @Override
    public void setWrappedMessages(List<MessageContainer> messages) {
        for (MessageContainer message : messages) {
            if (message instanceof PromotionMessageContainer) continue;
            throw new RuntimeException("All wrapped messages must be of type " + PromotionMessageContainer.class.getName());
        }
        super.setWrappedMessages(messages);
    }

    public List<PromotionMessageContainer> getPromoMessages() {
        ArrayList<PromotionMessageContainer> list = new ArrayList<PromotionMessageContainer>();
        for (MessageContainer message : this.getWrappedMessages()) {
            if (!(message instanceof PromotionMessageContainer)) continue;
            list.add((PromotionMessageContainer)message);
        }
        return list;
    }

    public void setBucketNumber(int bucket) {
        this.put(KEY_BUCKET_NUMBER, bucket);
    }

    public int getBucketNumber() {
        Long num = this.getLong(KEY_BUCKET_NUMBER);
        if (num == null) {
            return -1;
        }
        return num.intValue();
    }
}

