/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.promotion.containers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.limewire.io.BadGGEPBlockException;
import org.limewire.io.GGEP;
import org.limewire.io.IOUtils;
import org.limewire.promotion.containers.MapMessageContainer;
import org.limewire.promotion.containers.MessageContainer;
import org.limewire.promotion.containers.MessageContainerParser;
import org.limewire.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiMessageContainer
extends MapMessageContainer {
    private static final String KEY_WRAPPED_BYTES = "W";

    @Override
    public byte[] getType() {
        return StringUtils.toUTF8Bytes("MULT");
    }

    @Override
    public void decode(GGEP rawGGEP) throws BadGGEPBlockException {
        if (!rawGGEP.hasKey(KEY_WRAPPED_BYTES)) {
            throw new BadGGEPBlockException("Missing wrappedBytes");
        }
        super.decode(rawGGEP);
    }

    private byte[] getWrappedBytes() {
        byte[] bytes = this.getBytes(KEY_WRAPPED_BYTES);
        try {
            if (bytes != null) {
                return IOUtils.inflate(bytes);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new byte[0];
    }

    public List<MessageContainer> getWrappedMessages() {
        ArrayList<MessageContainer> list = new ArrayList<MessageContainer>();
        byte[] bytes = this.getWrappedBytes();
        if (bytes.length > 0) {
            int[] nextOffset = new int[1];
            int offset = 0;
            MessageContainerParser parser = new MessageContainerParser();
            while (offset < bytes.length) {
                try {
                    list.add(parser.parse(new GGEP(bytes, offset, nextOffset)));
                    offset = nextOffset[0];
                }
                catch (BadGGEPBlockException ex) {
                    throw new RuntimeException("Parsing error: ", ex);
                }
            }
        }
        return list;
    }

    public void setWrappedMessages(List<MessageContainer> messages) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (MessageContainer message : messages) {
            try {
                out.write(message.encode());
            }
            catch (IOException ex) {
                throw new RuntimeException("IOException? WTF?", ex);
            }
        }
        this.put(KEY_WRAPPED_BYTES, IOUtils.deflate(out.toByteArray()));
    }
}

