/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.promotion.impressions;

import com.google.inject.Singleton;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.limewire.promotion.containers.PromotionMessageContainer;
import org.limewire.promotion.impressions.Impression;
import org.limewire.promotion.impressions.ImpressionsCollector;
import org.limewire.promotion.impressions.UserQueryEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public final class ImpressionsCollectorImpl
implements ImpressionsCollector {
    private Map<String, UserQueryEvent> queries = new Hashtable<String, UserQueryEvent>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<UserQueryEvent> getCollectedImpressions() {
        Map<String, UserQueryEvent> map = this.queries;
        synchronized (map) {
            return new HashSet<UserQueryEvent>(this.queries.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordImpression(String originalQuery, Date timeQueried, Date timeShown, PromotionMessageContainer promo, String binderUniqueName) {
        UserQueryEvent event = this.queries.get(this.getMapKey(originalQuery, timeQueried));
        Map<String, UserQueryEvent> map = this.queries;
        synchronized (map) {
            if (event == null) {
                event = new UserQueryEvent(originalQuery, timeQueried);
                this.queries.put(this.getMapKey(originalQuery, timeQueried), event);
            }
            event.addImpression(new Impression(promo, binderUniqueName, timeShown));
        }
    }

    private String getMapKey(String originalQuery, Date timeQueried) {
        return originalQuery + ":" + timeQueried.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeImpressions(Set<UserQueryEvent> events) {
        Map<String, UserQueryEvent> map = this.queries;
        synchronized (map) {
            for (UserQueryEvent event : events) {
                this.queries.remove(this.getMapKey(event.getOriginalQuery(), event.getOriginalQueryTime()));
            }
        }
    }
}

